<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid",'answerid');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $sessionid = $_GET["sessionid"];
    $answerid = $_GET['answerid'];
    $out = new stdClass();
    
    //Verificamos que la sesion no este expirada
    $userid = isSessionValid($db, $sessionid);
    
    $sql = "SELECT COUNT(*) cnt " .
    "       FROM   userprivileges " .
    "       WHERE  userid=" . $userid . " " . 
    "       AND    privilegeid >= 47".
    "       AND    privilegeid <= 73";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error. "fallo privilegios"));
    
    $row = $rs->fetch_assoc();
    
    //Validamos que el usuario tenga privilegios coordinador, si no validamos que tenga otro permiso
    if(!tienePrivilegio($db, $sessionid, 45) && !($row["cnt"] > 0)){
        badEnd("403", array("msg"=>"No tiene Privilegios".$row["cnt"]));
    }
    
    $queryAnswers = '';
    
    // Armamos la busqueda de las 30
    for($i = 0; $i < 30; $i++){
        $queryAnswer .= "       A.q".($i+1)." AS answer".($i+1).", ".
        "       C.q".($i+1)." AS correction".($i+1).", ".
        "       C.obs".($i+1)." AS observation".($i+1).", ";
    }
    
    $queryTotal = '';
    // Armamos el query para sumar su puntuacion
    for($i = 0; $i < 30; $i++){
        if($i == 0){
            $queryTotal .= "IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
        }else{
            $queryTotal .= "+IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
        }
    }
    
    // Obtenemos los detalles del examen
    $sql = "SELECT T.id AS testid, ".
    "       IF( ".
    "           C.id IS NULL, ".
    "           0, ".
    "           (SELECT (".$queryTotal.") AS total FROM corrections WHERE corrections.id = C.id)".
    "       ) AS score, ".
    "       T.name AS testname, ".
    "       T.level AS testlevel, ".
    "       A.id AS answerid, ".
    "       ".$queryAnswer.
    "       P.id AS pupilid, ".
    "       C.completed AS completed, " .
    "       CONCAT(LPAD(P.id,'5','0'),RIGHT(CRC32(P.id),2)) as pupilcode ".
    "       FROM tests T, pupils P, answers A".
    "       LEFT JOIN corrections C ON C.answerid = A.id ".
    "       WHERE A.id = ".$answerid.
    "       AND P.id = A.pupilid ".
    "       AND A.testid = T.id ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
    
    $row = $rs->fetch_assoc();

    $out->entry = new stdClass();
    $out->entry->id = (int)$row['answerid'];
    $out->entry->completed = $row['completed'];
    $out->entry->score = $row['score'];
    
    // Detalles de la prueba
    $out->entry->test = new stdClass();
    $out->entry->test->id = (int)$row['testid'];
    $out->entry->test->name = $row['testname'];
    $out->entry->test->testlevel = $row['testlevel'];
    
    // Detalles del alumno
    $out->entry->pupil = new stdClass();
    $out->entry->pupil->id = (int)$row['pupilid'];
    $out->entry->pupil->code = $row['pupilcode'];
    
    // Acomodamos las preguntas
    for($i = 0; $i < 30; $i++){
        $question = new stdClass();
        $question->id = $i+1;
        $question->answer = $row['answer'.($i+1)];
        $question->score = (float)$row['correction'.($i+1)];
        $question->scoreCompleted = $row['correction'.($i+1)];
        $question->observation = $row['observation'.($i+1)] == null ? '' : $row['observation'.($i+1)];
        $question->files = array();
        
        // Obtenemos los archivos de la pregunta
        $dir = "/uploads/answers/".$out->entry->id;
        if (file_exists("../../..".$dir)){
            $files = scandir("../../..".$dir);
            foreach ($files as $file){
                if (!in_array($file,array(".","..")) && substr($file,0,2) == str_pad($question->id,2,"0",STR_PAD_LEFT)){
                    $question->files [] = array("filename"=>$file, "url"=>$globalurl.$dir . "/" . $file);
                }
            }
        }
            
        // Obtenemos la pregunta
        $sql = "SELECT * FROM questions ".
        "       WHERE testid = ".$out->entry->test->id.
        "       AND ordinal = ".$question->id;
        if (!$quest=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
    
        $rowQ = $quest->fetch_assoc();
        
        // Detalles de la pregunta
        $question->question = new stdClass();
        $question->question->id = (int)$rowQ['id'];
        $question->question->idCompleted = $rowQ['id'];
        $question->question->ordinal = (int)$rowQ['ordinal'];
        $question->question->label = $rowQ['label'];
        $question->question->dsc = $rowQ['statement'];
        $datatype = $rowQ['imagetype'];
        if ($datatype != null){
            $type = explode("/",$datatype);
            if ($type[0]=="image"){
                $url = "/uploads/tests/".$out->entry->test->id."/".$question->question->id."/question.".$type[1];
                if (!file_exists("../../..".$url)){
                    $url = null;
                    $datatype = null;
                } else {
                    $url = $globalurl."/uploads/tests/".$out->entry->test->id."/".$question->question->id."/question.".$type[1];
                }
            }
        }
        
        $question->question->image = new stdClass();
        $question->question->image->url = $url;
        $question->question->image->type = $datatype;
        
        // Obtenemos las subpreguntas
        $sql = "SELECT * ".
        "       FROM options ".
        "       WHERE questionid = ".$question->question->id.
        "       ORDER BY ord ASC";
        if (!$opt=$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $question->options = [];
        while($rowO = $opt->fetch_assoc()){
            $option = new stdClass();
            $option->id = (int)$rowO['id'];
            $option->label = $rowO['label'];
            $option->dsc = $rowO['dsc'];
            $option->image = new stdClass();
            $datatype = $rowQ['imagetype'];
            if ($datatype != null){
                $type = explode("/",$datatype);
                if ($type[0]=="image"){
                    $url = "../uploads/tests/".$out->entry->test->id."/".$question->question->id."/".$option->id.".".$type[1];
                    if (!file_exists("../../".$url)){
                        $url = null;
                        $datatype = null;
                    }
                }
            }
            $option->image->url = $url;
            $option->image->type = $datatype;
            
            $question->options [] = $option;
        }
        
        $out->entry->questions [] = $question;
        
        // Validamos que tenga su examen corregido
        $sql = "SELECT * FROM corrections WHERE answerid = ".$out->entry->id;
        if (!$corr=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $corrections = $corr->fetch_assoc();
        
        // Si ya tiene un profesor obtenemos su nombre
        if ($corrections['corrector'] !== null) {
            
            $sql = "SELECT name FROM cmsusers WHERE id = ".$corrections['corrector'];
            if (!$corrU=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
        
            $corrector = $corrU->fetch_assoc();
            
            $out->entry->teachername = $corrector['name'];
        } else{
            $out->entry->teachername = '';
        }
    }
    
    $completed = true;
    
    if($row['completed'] == null){
        // Recorremos las preguntas para saber cual es la ultima y validar que todas estan corregidas
        foreach($out->entry->questions as $question){
            // Validamos que no sea null para saber que es una real
            if ($question->question->idCompleted != null) {
                // Recorremos las puntuaciones y observaciones
                if ($question->scoreCompleted == null || $question->observation == null || $question->observation == '') {
                    $completed = false;
                }
            }
        }
    }
    
    $out->entry->saved = $completed;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>