<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $regionPriv = '';
    
    //Verificamos que la sesion no este expirada
    $userid = isSessionValid($db, $sessionid);
    
    $sql = "SELECT COUNT(*) cnt " .
    "       FROM   userprivileges " .
    "       WHERE  userid=" . $userid . " " . 
    "       AND    privilegeid >= 47".
    "       AND    privilegeid <= 73";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error. "fallo privilegios"));
    
    $row = $rs->fetch_assoc();
    
    //Validamos que el usuario tenga privilegios coordinador, si no validamos que tenga otro permiso
    if(!($row["cnt"] > 0)){
        badEnd("403", array("msg"=>"No tiene Privilegios".$row["cnt"]));
    }
    
    // SI tienes mas de 1 privilegio, armamos un query con las regiones
    if($row["cnt"] > 0){
        $sql = "SELECT privileges.dsc AS dsc ".
        "       FROM userprivileges, privileges ".
        "       WHERE userprivileges.userid = ".$userid.
        "       AND userprivileges.privilegeid = privileges.id".
        "       AND privileges.grp = 'PROFESORES'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error. "fallo privilegios"));
        
        $count = 0;
        while($row = $rs->fetch_assoc()){
            if($count == 0){
                $regionPriv .= " AND ( schools.region = '".$row['dsc']."'";
            }else{
                 $regionPriv .= " OR schools.region = '".$row['dsc']."'";
            }
            $count++;
        }
        $regionPriv .= ")";
    }
    
    // Validamos primero que no este corrigiendo un examen
    $sql = "SELECT COUNT(*) AS qty FROM corrections ".
    "       WHERE corrector = ".$userid.
    "       AND completed IS NULL";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    // SI tiene aun un examen sin terminar de corregir, le damos ese id que no sea tramposo
    if ($row['qty'] > 0) {
        $out->qty = (int)$row['qty'];
        $sql = "SELECT answerid AS id FROM corrections ".
        "       WHERE corrector = ".$userid.
        "       AND completed IS NULL";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $row = $rs->fetch_assoc();
        $out->id = (int)$row['id'];
    } else {
        // Buscamos examenes en las regiones que tengan el usuario
        $sql = "SELECT COUNT(pupils.id) AS qty ".
        "       FROM schools, pupils, answers, tests".
        "       WHERE schools.id = pupils.schoolid ".
        "       ".$regionPriv.
        "       AND answers.pupilid = pupils.id".
        "       AND tests.id = answers.testid ".
        "       AND tests.name LIKE '%Nacional%'".
        "       AND NOT EXISTS(SELECT * FROM corrections WHERE corrections.answerid = answers.id)";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        
        if ($row['qty'] > 0) {
            $out->qty = (int)$row['qty'];
            // Buscamos el id de algun examen por orden de llegada
            $sql = "SELECT answers.id AS id".
            "       FROM schools, pupils, answers, tests".
            "       WHERE schools.id = pupils.schoolid ".
            "       ".$regionPriv.
            "       AND answers.pupilid = pupils.id".
            "       AND tests.id = answers.testid ".
            "       AND tests.name LIKE '%Nacional%'".
            "       AND NOT EXISTS(SELECT * FROM corrections WHERE corrections.answerid = answers.id)".
            "       ORDER BY pupils.level DESC, RAND() LIMIT 1";
            if (!$rs=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
                
            $row = $rs->fetch_assoc();
            $out->id = (int)$row['id'];
        }else{
            $out->qty = (int)$row['qty'];
        }
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>