<?php
    header("Content-Type:application/json");
    include_once("../connection.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("rolid","privileges","sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $rolid = $_GET["rolid"];
    $privileges = $_GET["privileges"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 29))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // Se eliminan los privilegios anteriores del rol
    $sql = "DELETE FROM userprivileges WHERE userid=" . $rolid;
    if (!$db->query($sql))
        badEnd("500", array(msg=>$db->error));
    // Se eliminan los privilegios anteriores de los usuarios que tienen el rol asignado
    $sql = "DELETE FROM userprivileges WHERE userid IN " . 
                   "(SELECT id FROM cmsusers WHERE rolid=" . $rolid . ")";
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Insertamos los privilegios
    $sql =  "INSERT INTO userprivileges(userid, privilegeid) " . 
    "       VALUES".validateInsert($privileges, $rolid);
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    //Obtenemos los usuarios que tienen el rolid
    $sql = "SELECT id FROM cmsusers WHERE type = 1 AND rolid = ".$rolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    while($row = $rs->fetch_assoc()){
        // Se asignan los nuevos privilegios a los usuarios que tengan el rol asignado
        $sql =  "INSERT INTO userprivileges(userid, privilegeid) " . 
        "       VALUES".validateInsert($privileges, $row["id"]);
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    }
    
    $out->rolid = $rolid;
    
    $sql = "SELECT name FROM cmsusers WHERE type = 0 AND id = ".$rolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    setAudit($db, "ROLES", $sessionid, "Se actualizaron los privilegios del rol ".$row['name']);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function validateInsert($privileges,$rolid){
        //Separamos cada privilegio para crear cadena e insertarlos
        $privs = explode("-", $privileges);
        $insertString = "";
        
        foreach ($privs as $priv){
            $insertString = $insertString."(".$rolid.", ".$priv."),";
        }
        
        return substr($insertString, 0, -1);
    }
?>