<?php
    header("Content-Type:application/json");
    include_once("../connection.php");
    include_once("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("userid","privileges","sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $userid = $_GET["userid"];
    $privileges = $_GET["privileges"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 25))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // Se eliminan los privilegios anteriores
    $sql = "DELETE FROM userprivileges WHERE userid=" . $userid;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    
    $sql = "INSERT INTO userprivileges (userid, privilegeid)".
    "       VALUES ".insertData($privileges,$userid);
    if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
    function insertData($privileges,$userid){
        $privs = explode("-", $privileges);
        $len = sizeof($privs);
        $str = "";
        for($i = 0; $i < $len; $i++){
            $str.= "(".$userid.",".$privs[$i]."),";
        }
        return substr($str, 0, -1);;
    }
    
    $out->userid = $userid;
    
    $sql = "SELECT name FROM cmsusers WHERE type = 1 AND id = ".$userid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    setAudit($db, "USUARIOS", $sessionid, "Se actualizaron los privilegios del usuario ".$row['name']);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>