<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","pupilid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $pupilid = $_GET["pupilid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 10))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // Datos del alumno
    $sql = "SELECT name, surname FROM pupils WHERE id = ".$pupilid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    //Validamos que no tenga examenes
    $sql = "SELECT count(id) as qtyTests FROM answers WHERE pupilid=".$pupilid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $existtest = $rs->fetch_assoc();
    
    //Si no posee examenes podemos eliminarlo
    if($existtest["qtyTests"] == 0){
        $sql = "DELETE FROM pupils WHERE id=".$pupilid;
        if (!$rs=$db->query($sql)){
            if ($db->errno == 1451)
            badEnd("304",array("msg"=>"Existen dependencias que no permiten eliminar el registro"));
        else
            badEnd("500", array("msg"=>$db->error));
        }
        
        setAudit($db, "ALUMNOS", $sessionid, "Se elimino el alumno ".$row['name']." ".$row['surname']);
    }else{
        badEnd("304",array("msg"=>"No puede ser borrado el registro ya que posee examenes"));
    }
    
    $out->id = $pupilid;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>