<?php ini_set("memory_limit","-1")?>
<?php 
    header("Content-Type:application/json; charset=UTF-8");
    header('Content-Encoding: UTF-8');
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","order","numofrecords","offset");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $order = "";
    $number = $_GET["numofrecords"];
    $offset = $_GET["offset"];
    $level = "";
    $schoolid = "";
    $region = "";
    $filter = "";
    $test = '';
    $schooltype = '';
    $kindTests = determinateKindTests($_GET['kindTests']);
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 8))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    if(isset($_GET["order"]) && $_GET["order"] != ""){
        $order = " ORDER BY ".$_GET["order"]." ";
    }
    
    if(isset($_GET["region"]) && $_GET["region"] != ""){
        $region = " AND schools.region = '".$_GET["region"]."' ";
    }
    
    if(isset($_GET["schoolid"]) && $_GET["schoolid"] != ""){
        $schoolid = "AND schools.id = ".$_GET["schoolid"]." ";
    }
    
    if(isset($_GET["level"]) && $_GET["level"] != ""){
        $level = " AND pupils.level = ".$_GET["level"]." ";
    }
    
    if(isset($_GET['test']) && $_GET['test'] != ''){
        if($_GET['test'] == '0'){
            $test = " AND (SELECT COUNT(answers.id) ".
            "       FROM answers ".
            "       WHERE answers.pupilid = pupils.id) = 0 ";
        }else{
            $test = " AND (SELECT COUNT(answers.id) ".
            "       FROM answers, tests ".
            "       WHERE answers.pupilid = pupils.id ".
            "       AND tests.id = answers.testid ".
            "       AND tests.name LIKE '%".$_GET['test']."%' ) > 0 ";
        }
    }
    
    if(isset($_GET["schooltype"]) && $_GET["schooltype"] != ""){
        $schooltype = " AND schools.private = ".$_GET["schooltype"]." ";
    }
    
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        
        $filterarr = explode(' ',$_GET['filter']);
        $str = '';
        
        foreach($filterarr as $index => $fil){
            if($index == 0){
                $str .= " OR ( pupils.name LIKE '%".$fil."%' ";
            }else{
                $str .= " AND pupils.surname LIKE '%".$fil."%' ";
            }
        }
        
        if($str != ''){
            $str .= " ) ";
        }
        
        $filter = " AND (".
        "       CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2)) LIKE '%".$_GET['filter']."%' ".
        "       ".$str.
        "       OR pupils.name LIKE '%".$_GET['filter']."%'".
        "       OR pupils.surname LIKE '%".$_GET['filter']."%'".
        "       OR CONCAT(pupils.name,' ', pupils.surname) LIKE '%".$_GET['filter']."%'".
        "       OR pupils.ci LIKE '%".$_GET['filter']."%' ".
        "       OR schools.name LIKE '%".$_GET['filter']."%'".
        "       OR schools.region LIKE '%".$_GET['filter']."%'".
        "       )";
    }
    
    //Contamos el total de alumnos existentes
    $sql = "SELECT count(DISTINCT pupils.id) as number ".
    "       FROM schools, pupils ".
    "       LEFT JOIN answers an ON an.pupilid = pupils.id ".
    "       LEFT JOIN tests test ON an.testid = test.id".
    "       WHERE pupils.schoolid = schools.id ".
    "       ".$region.
    "       ".$test.
    "       ".$filter.
    "       ".$level.
    "       ".$schooltype.
    "       ".$kindTests.
    "       ".$schoolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row = $rs->fetch_assoc();
    
    //Guardamos el total de alumnos existentes
    $out->numofrecords = (int)$row["number"];
    
    //Traemos los codigos de los alumnos
    $sql = "SELECT DISTINCT pupils.*, schools.id as collegeId,".
    "       CONCAT(LPAD(pupils.id,'7','0'),RIGHT(CRC32(pupils.id),2)) as code, ".
    "       (SELECT COUNT(answers.id) ".
    "          FROM answers ".
    "          WHERE answers.pupilid = pupils.id ".
    "          AND answers.imgtype IS NOT NULL) AS kindTest,".
    "       schools.code as collegeCode, schools.name as collegeName,".
    "       schools.region as collegeRegion, schools.private as collegePriv, schools.email as collegeEmail ".
    "       FROM schools, pupils ".
    "       LEFT JOIN answers an ON an.pupilid = pupils.id ".
    "       LEFT JOIN tests test ON an.testid = test.id".
    "       WHERE pupils.schoolid = schools.id ".
    "       ".$region.
    "       ".$test.
    "       ".$filter.
    "       ".$level.
    "       ".$schoolid.
    "       ".$schooltype.
    "       ".$kindTests.
    "       ".$order.
    "       LIMIT ".$offset.",".$number;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error.$sql));
        
    while($student= $rs->fetch_assoc()){
        $record = new stdClass();
        $record->pupil = new stdClass();
        $record->pupil->id = (int)$student["id"];
        
        $record->pupil->code = $student["code"];
        $record->pupil->ci = $student["ci"];
        $record->pupil->name = $student["name"];
        $record->pupil->surname = $student["surname"];
        $record->pupil->gender = new stdClass();
        $record->pupil->gender->id = $student["gender"];
        $record->pupil->gender->dsc = $student["gender"] == "M" ? "Masculino" : "Femenino";
        
        $dateFormat = strtotime($student["birthdate"]);
    
        $record->pupil->birthdate = new stdClass();
        $record->pupil->birthdate->date = date("Y",$dateFormat).date("m",$dateFormat).date("d",$dateFormat);
        $record->pupil->birthdate->formatted = $student["birthdate"];
        $record->pupil->level = (int)$student["level"];
        $record->pupil->section = $student["section"];
        
        $record->school = new stdClass();
        
        $record->school->id = (int)$student["collegeId"];
        $record->school->code = $student["collegeCode"];
        $record->school->name = $student["collegeName"];
        $record->school->region = $student["collegeRegion"];
        $record->school->private = $student["collegePriv"] == 1 ? true : false;
        $record->school->email = $student["collegeEmail"];
        
        $record->results = new stdClass();
        
        $record->results->correct = 0;
        
        // Obtenemos los resultados del alumno
        $sql = "SELECT answers.id AS answerid, ".
        "       answers.datestart AS date, ".
        "       tests.id AS testid, ".
        "       tests.name AS testname, ".
        "       tests.*, ".
        "       tests.level AS testlevel ".
        "       FROM answers, tests ".
        "       WHERE pupilid = ".$record->pupil->id.
        "       AND tests.id = answers.testid";
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        while($exams = $res->fetch_assoc()){
            $ex = new stdClass();
            $ex->id = (int)$exams['answerid'];
            
            $ex->test = new stdClass();
            $ex->test->id = (int)$exams['testid'];
            $ex->test->name = $exams['testname'];
            $ex->test->level = (int)$exams['testlevel'];
            
            // Obtenemos el score
            // Si es preeliminar
            if (stripos($ex->test->name, 'preliminar') !== false) {
                // Consultamos emparejando con las preferencias
                $sql = "SELECT pupils.*, ".
                "       ".queryForScore(30).
                "       FROM pupils ".
                "       LEFT JOIN answers an ON an.pupilid = pupils.id ".
                "       LEFT JOIN tests test ON an.testid = test.id ".
                "       WHERE pupils.id = ".$record->pupil->id;
                if (!$resScore=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $score = $resScore->fetch_assoc();
                $record->results->preeliminar = (float)$score['score'];
                $record->results->correct = (float)$score['score'];
                
                // Si es regional
            } else if (stripos($ex->test->name, 'regional') !== false) {
                $queryTotal = '';
                // Armamos el query para sumar su puntuacion
                for($i = 0; $i < 30; $i++){
                    if($i == 0){
                        $queryTotal .= "IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
                    }else{
                        $queryTotal .= "+IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
                    }
                }
                $sql = "SELECT DISTINCT".
                "       IF( ".
                "           C.id IS NULL, ".
                "           0, ".
                "           (SELECT (".$queryTotal.") AS total FROM corrections WHERE corrections.id = C.id)".
                "       ) AS score ".
                "       FROM tests test, pupils,  answers an ".
                "       LEFT JOIN corrections C ON C.answerid = an.id".
                "       WHERE an.pupilid = pupils.id ".
                "       AND an.testid = test.id ".
                "       AND test.name LIKE '%Prueba Regional%' ".
                "       AND pupils.id = ".$record->pupil->id;
                if (!$resScore=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $score = $resScore->fetch_assoc();
                $record->results->regional = (float)$score['score'];
                // Si es nacional
            } else if (stripos($ex->test->name, 'nacional') !== false) {
                $queryTotal = '';
                // Armamos el query para sumar su puntuacion
                for($i = 0; $i < 30; $i++){
                    if($i == 0){
                        $queryTotal .= "IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
                    }else{
                        $queryTotal .= "+IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
                    }
                }
                $sql = "SELECT DISTINCT".
                "       IF( ".
                "           C.id IS NULL, ".
                "           0, ".
                "           (SELECT (".$queryTotal.") AS total FROM corrections WHERE corrections.id = C.id)".
                "       ) AS score ".
                "       FROM tests test, pupils,  answers an ".
                "       LEFT JOIN corrections C ON C.answerid = an.id".
                "       WHERE an.pupilid = pupils.id ".
                "       AND an.testid = test.id ".
                "       AND test.name LIKE '%Prueba Nacional%' ".
                "       AND pupils.id = ".$record->pupil->id;
                if (!$resScore=$db->query($sql))
                    badEnd("500", array("msg"=>$db->error));
                    
                $score = $resScore->fetch_assoc();
                $record->results->nacional = (float)$score['score'];
            }
            
        }
        
        $record->modalidad = $student['kindTest'] > 0 ? 'Presencial' : 'Virtual';

        $records [] = $record;
    }
    
    $out->records = $records;
    
    $parmsob = array("csv");
    if (parametrosValidos($_GET, $parmsob)){
        //eliminar documentos anteriores
        $files = glob('exports/*');
        foreach($files as $file){
            if(is_file($file))
                unlink($file);
        }
        
        //Eliminar zip anterior
        $files = glob('*.zip');
        foreach($files as $file){
            if(is_file($file))
                unlink($file);
        }
        
        // Abrimos un archivo global
        $csvall = fopen('exports/TODOS.csv','w');
        
        fwrite($csvall, $BOM);
        $line = array('COD.','GRADO','SECCIÓN','NOMBRE','APELLIDO','CI','FEC. NAC', 'GÉNERO','ESTADO','COLEGIO','TIPO','PREELIMINAR','REGIONAL','NACIONAL','MODALIDAD');
        $line = array_map("utf8_decode", $line);
        fputcsv($csvall, $line, ';', '"');
        
        for($i = 0; $i < $number; $i++){
            if($i == 0){
                $csv[$out->records[$i]->school->name] = fopen('exports/'.$out->records[$i]->school->name.".csv", 'w');
                
                fwrite($csv[$out->records[$i]->school->name], $BOM);
                $line = array('COD.','GRADO','SECCIÓN','NOMBRE','APELLIDO','CI','FEC. NAC', 'GÉNERO','ESTADO','COLEGIO','TIPO','PREELIMINAR','REGIONAL','NACIONAL','MODALIDAD');
                $line = array_map("utf8_decode", $line);
                fputcsv($csv[$out->records[$i]->school->name], $line, ';', '"');
            }
            
            if(!array_key_exists($out->records[$i]->school->name,$csv)){
                $csv[$out->records[$i]->school->name] = fopen('exports/'.$out->records[$i]->school->name.".csv", 'w');
                
                fwrite($csv[$out->records[$i]->school->name], $BOM);
                $line = array('COD.','GRADO','SECCIÓN','NOMBRE','APELLIDO','CI','FEC. NAC', 'GÉNERO','ESTADO','COLEGIO','TIPO','PREELIMINAR','REGIONAL','NACIONAL','MODALIDAD');
                $line = array_map("utf8_decode", $line);
                fputcsv($csv[$out->records[$i]->school->name], $line, ';', '"');
            }
            
            $arr[$i] = array( $out->records[$i]->pupil->code,
                $out->records[$i]->pupil->level,
                $out->records[$i]->pupil->section,
                $out->records[$i]->pupil->name,
                $out->records[$i]->pupil->surname,
                $out->records[$i]->pupil->ci,
                $out->records[$i]->pupil->birthdate->formatted,
                $out->records[$i]->pupil->gender->id,
                $out->records[$i]->school->region,
                $out->records[$i]->school->name,
                ($out->records[$i]->school->private == true ? 'Privado' : 'Oficial'),
                $out->records[$i]->results->preeliminar,
                $out->records[$i]->results->regional,
                $out->records[$i]->results->nacional,
                $out->records[$i]->modalidad);
        }
        
        for($i = 0; $i < $number; $i++){
            $arr[$i] = array_map("utf8_decode", $arr[$i]);
            fputcsv($csv[$out->records[$i]->school->name], $arr[$i],';');
            fputcsv($csvall, $arr[$i],';');
        }
        
        for($i = 0; $i < sizeof($csv); $i++){
            if(array_key_exists($out->records[$i]->school->name,$csv)){
                fclose($csv[$out->records[$i]->school->name]);
                unset($csv[$out->records[$i]->school->name]);
            }
        }
        
        fclose($csvall);
        
        $pathdir = "exports/";  
        $zipname = "schools_data.zip"; 
        $zip = new ZipArchive; 
   
        if($zip -> open($zipname, ZipArchive::CREATE ) === TRUE) {
            $dir = opendir($pathdir); 
       
            while($file = readdir($dir)) { 
                if(is_file($pathdir.$file)) { 
                    $zip -> addFile($pathdir.$file, $file); 
                } 
            } 
            
        $zip ->close(); 
        }
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function queryForScore($questionsqty){
        $str = ' IF(test.id IS NULL, 0, ( test.ptsini ';
        
        for($i = 1; $i <= $questionsqty; $i++){
            $str .= " + 
            IF(test.q$i = 0, 0, 
                IF(test.q$i = an.q$i, 
           	    	CASE
               	    	WHEN test.dif$i = 1 THEN test.ptsoklow
                    	WHEN test.dif$i = 2 THEN test.ptsokmid
                    	WHEN test.dif$i = 3 THEN test.ptsokhigh
              	    END,
              	    CASE
                   		WHEN test.dif$i = 1 THEN -test.ptsbadlow
                   		WHEN test.dif$i = 2 THEN -test.ptsbadmid
                   		WHEN test.dif$i = 3 THEN -test.ptsbadhigh
                   	END
                ) 
            ) ";
        }
        
        $str .= ' ) ) AS score ';
        
        return $str;
    }
    
    function queryForScoreOrder($questionsqty){
        $str = ' IF(test.id IS NULL, 0, ( test.ptsini ';
        
        for($i = 1; $i <= $questionsqty; $i++){
            $str .= " + 
            IF(test.q$i = 0, 0, 
                IF(test.q$i = an.q$i, 
           	    	CASE
               	    	WHEN test.dif$i = 1 THEN test.ptsoklow
                    	WHEN test.dif$i = 2 THEN test.ptsokmid
                    	WHEN test.dif$i = 3 THEN test.ptsokhigh
              	    END,
              	    CASE
                   		WHEN test.dif$i = 1 THEN -test.ptsbadlow
                   		WHEN test.dif$i = 2 THEN -test.ptsbadmid
                   		WHEN test.dif$i = 3 THEN -test.ptsbadhigh
                   	END
                ) 
            ) ";
        }
        
        $str .= ' ) ) DESC';
        
        return $str;
    }
    // 1 = es igual a presencial
    // 2 = es igual a virtual
    function determinateKindTests($kind){
        $str = '';
        
        switch($kind){
            case 1:
                $str = " AND (SELECT COUNT(answers.id) ".
                    "       FROM answers ".
                    "       WHERE answers.pupilid = pupils.id ".
                    "       AND answers.imgtype IS NOT NULL) > 0 ";
                break;
            case 2:
                $str = " AND (SELECT COUNT(answers.id) ".
                    "       FROM answers ".
                    "       WHERE answers.pupilid = pupils.id ".
                    "       AND answers.imgtype IS NULL) > 0 ";
                break;
        }
        
        return $str;
    }
?>