<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");

    $parmsob = array("sessionid","id","schoolid","name","surname","ci","gender","birthdate","level","section");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    
    $pupilid = $_GET["id"];
    $schoolid = $_GET["schoolid"];
    $name = $_GET["name"];
    $surname = $_GET["surname"];
    $ci = $_GET["ci"];
    $gender = $_GET["gender"];
    $birth = $_GET["birthdate"];
    $level = $_GET["level"];
    $section = $_GET["section"];
    $observation = '';
    
    if(isset($_GET['observation']) && $_GET['observation'] != '' ){
        $observation = $_GET['observation'];
    }
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    if($pupilid == 0){
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid,11))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "SELECT sum(qty) as estimated FROM estimatedpupils WHERE schoolid=".$schoolid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $estimated = $rs->fetch_assoc();
        
        $sql = "SELECT count(id) as registered FROM pupils WHERE schoolid=".$schoolid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $registered = $rs->fetch_assoc();
        
        if($estimated["estimated"] > $registered["registered"]){
            
            $sql = "INSERT INTO pupils(schoolid, name, surname, ci, gender, birthdate, level, section, observation) ".
            "       VALUES(".$schoolid.", '".$name."', '".$surname."', '".($ci == 0 ? "" : $ci)."', '".$gender."', '".$birth."', ".$level.", '".$section."','".$observation."')";
            if (!$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $out->id = $db->insert_id;
    
            setAudit($db, "ALUMNOS", $sessionid, "Se agregó el alumno ".$name." ".$surname);
            
        }else{
            badEnd("203", array("msg"=>"No tiene mpas cupos disponibles"));
        }
    }else{
        
        //Validamos que el usuario tenga privilegios
        if(!tienePrivilegio($db, $sessionid, 9))
            badEnd("403", array("msg"=>"No tiene Privilegios"));
        
        $sql = "SELECT id FROM pupils WHERE id=".$pupilid;
        if (!$rs = $db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $row = $rs->fetch_assoc();
        if ($row["id"] != $pupilid)
            badEnd("204", array("msg"=>"No se encontró el registro"));
            
        $sql = "UPDATE pupils SET ".
        "       name='".$name."', surname='".$surname."',".
        "       ci='".($ci == 0 ? "" : $ci)."', gender='".$gender."',".
        "       birthdate='".$birth."', level=".$level.",".
        "       observation = '".$observation."', ".
        "       section='".$section."' WHERE id=".$pupilid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        //Verificamos que se hicieron cambios
        if($db->affected_rows == 0){
            badEnd("304", array("msg"=>"No se pudo modificar"));
        }
        
        setAudit($db, "ALUMNOS", $sessionid, "Se actualizó el alumno ".$name." ".$surname);
        
        $out->id= $pupilid;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>