<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","offset","numofrecords","order");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $sessionid = $_GET["sessionid"];
    $filter = '';
    $region = '';
    $schoolid = '';
    $level = '';    
    $offset = $_GET["offset"];
    $number = $_GET["numofrecords"];
    $order = $_GET["order"];
    $status = '';
    $prof = '';
    $regionPriv = '';
    $isAdmin = false;
    
    $out = new stdClass();
    
    //Verificamos que la sesion no este expirada
    $userid = isSessionValid($db, $sessionid);
    
    $sql = "SELECT COUNT(*) cnt " .
    "       FROM   userprivileges " .
    "       WHERE  userid=" . $userid . " " . 
    "       AND    privilegeid >= 47".
    "       AND    privilegeid <= 73";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error. "fallo privilegios"));
    
    $row = $rs->fetch_assoc();
    
    //Validamos que el usuario tenga privilegios coordinador, si no validamos que tenga otro permiso
    if(!tienePrivilegio($db, $sessionid, 45) && !($row["cnt"] > 0)){
        badEnd("403", array("msg"=>"No tiene Privilegios".$row["cnt"]));
    }
    
    if(tienePrivilegio($db, $sessionid, 45)){
        $isAdmin = true;
    }
    
    // SI tienes mas de 1 privilegio, armamos un query con las regiones
    if($row["cnt"] > 0 && !$isAdmin){
        $sql = "SELECT privileges.dsc AS dsc ".
        "       FROM userprivileges, privileges ".
        "       WHERE userprivileges.userid = ".$userid.
        "       AND userprivileges.privilegeid = privileges.id".
        "       AND privileges.grp = 'PROFESORES'";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error. "fallo privilegios"));
        
        $count = 0;
        while($row = $rs->fetch_assoc()){
            if($count == 0){
                $regionPriv .= " AND ( schools.region = '".$row['dsc']."'";
            }else{
                 $regionPriv .= " OR schools.region = '".$row['dsc']."'";
            }
            $count++;
        }
        $regionPriv .= ")";
    }
    
    // SI recibimos filter, armamos el query
    if( isset($_GET['filter']) && $_GET['filter'] != '' ){
        $filter = " AND (".
        "       CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2)) LIKE '%".$_GET['filter']."%' ".
        "       ".($isAdmin ? "OR CONCAT(pupils.name,' ', pupils.surname) LIKE '%".$_GET['filter']."%'" : '').
        "       OR pupils.ci LIKE '%".$_GET['filter']."%' ".
        "       OR schools.region LIKE '%".$_GET['filter']."%'".
        "       )";
    }
    
    // SI recibimos level, armamos el query
    if( isset($_GET['level']) && $_GET['level'] != '' ){
        $level = " AND pupils.level=".$_GET['level'];
    }
    
    // SI recibimos teacher, armamos el query
    if( isset($_GET['teacher']) && $_GET['teacher'] != '' ){
        $prof = " AND C.corrector=".$_GET['teacher'];
    }
    
    // SI recibimos status, armamos el query
    if( isset($_GET['status']) && $_GET['status'] != '' ){
        // SI es 1, examenes corregidos
        if($_GET['status'] == 1){
             $status = " AND C.completed IS NOT NULL";
            // Si es 2, examene no corregidos
        }else if($_GET['status'] == 2){
             $status = " AND C.completed IS NULL";
        }
       
    }
    
    // SI recibimos region, armamos el query
    if( isset($_GET['regionid']) && $_GET['regionid'] != '' ){
        $region = " AND schools.region='".$_GET['regionid']."'";
    }
    
    // SI recibimos schoolid, armamos el query
    if( isset($_GET['schoolid']) && $_GET['schoolid'] != '' ){
        $schoolid = " AND schools.id=".$_GET['schoolid'];
    }
    
    //Contamos el total de alumnos existentes
    $sql = "SELECT count(pupils.id) as number ".
    "       FROM schools, tests test, pupils,  answers an ".
    "       LEFT JOIN corrections C ON C.answerid = an.id".
    "       WHERE pupils.schoolid = schools.id".
    "       AND an.pupilid = pupils.id ".
    "       AND an.testid = test.id ".
    "       AND test.name LIKE '%Prueba Regional%' ".
    "       ".$region.
    "       ".$level.
    "       ".$filter.
    "       ".$prof.
    "       ".$status.
    "       ".$regionPriv.
    "       ".$schoolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error. "fallo cantidad"));
    
    $row = $rs->fetch_assoc();
    
    //Guardamos el total de alumnos existentes
    $out->numofrecords = (int)$row["number"];
    
    $queryTotal = '';
    // Armamos el query para sumar su puntuacion
    for($i = 0; $i < 30; $i++){
        if($i == 0){
            $queryTotal .= "IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
        }else{
            $queryTotal .= "+IF(q".($i+1)." IS NULL, 0 , q".($i+1).")";
        }
    }
    $sql = "SELECT DISTINCT pupils.*, schools.id as collegeId,".
    "       IF( ".
    "           C.id IS NULL, ".
    "           0, ".
    "           (SELECT (".$queryTotal.") AS total FROM corrections WHERE corrections.id = C.id)".
    "       ) AS score, ".
    "       test.id AS testid, an.id AS respId, ".
    "       CONCAT(LPAD(pupils.id,'5','0'),RIGHT(CRC32(pupils.id),2)) as code, ".
    "       schools.code as collegeCode, schools.name as collegeName,".
    "       schools.region as collegeRegion, schools.private as collegePriv, schools.email as collegeEmail ".
    "       FROM schools, tests test, pupils,  answers an ".
    "       LEFT JOIN corrections C ON C.answerid = an.id".
    "       WHERE pupils.schoolid = schools.id".
    "       AND an.pupilid = pupils.id ".
    "       AND an.testid = test.id ".
    "       AND test.name LIKE '%Prueba Regional%' ".
    "       ".$region.
    "       ".$level.
    "       ".$filter.
    "       ".$prof.
    "       ".$status.
    "       ".$regionPriv.
    "       ".$schoolid.
    "       ORDER BY ".$order." ".
    "       LIMIT ".$offset.",".$number." ";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error . "toda la data  ".$sql));
    
    while($student = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->pupil = new stdClass();
        $record->school = new stdClass();
        
        $record->pupil->id = (int)$student["id"];
        
        $record->pupil->code = $student["code"];
        
        if($isAdmin){
            $record->pupil->ci = $student["ci"];
            $record->pupil->name = $student["name"];
            $record->pupil->surname = $student["surname"];
            $record->pupil->gender = new stdClass();
            $record->pupil->gender->id = $student["gender"];
            $record->pupil->gender->dsc = $student["gender"] == "M" ? "Masculino" : "Femenino";
            $record->pupil->birthdate = new stdClass();
            $record->pupil->birthdate->date = date("Ymd",strtotime($student["birthdate"]));
            $record->pupil->birthdate->formatted = $student["birthdate"];
            
            $record->school->code = $student["collegeCode"];
            $record->school->name = $student["collegeName"];
            $record->school->private = $student["collegePriv"] == 1 ? true : false;
            $record->school->email = $student["collegeEmail"];
        }
        
        $record->pupil->level = (int)$student["level"];
        $record->pupil->section = $student["section"];
        
        $record->school->id = (int)$student["collegeId"];
        $record->school->region = $student["collegeRegion"];
        
        $idPupil = $student["id"] == 0 ? 1 : $student["id"];
        $sql = "SELECT answers.id AS id ".
        "       FROM answers, tests ".
        "       WHERE answers.pupilid =".$record->pupil->id.
        "       AND tests.id = answers.testid".
        "       AND tests.name LIKE '%Prueba Regional%'";
        if (!$exam=$db->query($sql))
            badEnd("500", array("msg"=>$db->error . "fallo contador ".$student["id"]));
        
        $resexam = $exam->fetch_assoc();
        
        $record->test = new stdClass();
        $record->test->id = (int)$resexam['id'];
        
        // Validamos que tenga su examen corregido
        $sql = "SELECT * FROM corrections WHERE answerid = ".$record->test->id;
        if (!$corr=$db->query($sql))
            badEnd("500", array("msg"=>$db->error . "fallo contador ".$student["id"]));
        
        $corrections = $corr->fetch_assoc();
        
        $record->qualification = $student["score"];
        
        // Si ya tiene un profesor obtenemos su nombre
        if ($corrections['corrector'] !== null) {
            
            $sql = "SELECT name FROM cmsusers WHERE id = ".$corrections['corrector'];
            if (!$corrU=$db->query($sql))
                badEnd("500", array("msg"=>$db->error . "fallo contador ".$student["id"]));
        
            $corrector = $corrU->fetch_assoc();
            
            $record->teachername = $corrector['name'];
        } else{
            $record->teachername = '';
        }
        
        
        $records [] = $record;
    }
    
    $out->records = $records;

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>