<?php

    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","offset");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $offset = $_GET["offset"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Obtendremos la cantidad de regiones existentes
    $sql = "SELECT COUNT(DISTINCT region) AS totally FROM schools";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row= $rs->fetch_array();
    $number = $row["totally"];
    
    //Obtenemos las regiones que se encuentran en la BD
    $sql = "SELECT DISTINCT region FROM schools ORDER BY region";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    
    for($i = 0; $i < $number; $i++){
        $row= $rs->fetch_array();
        $out->numofrecords++;
        $out->records[$i] = new stdClass();
        $out->records[$i]->region=$row["region"];
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>