<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","offset","numofrecords");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $offset = $_GET["offset"];
    $order = determinateOrder($_GET["order"]);
    $numofrecords = $_GET["numofrecords"];
    $filter = '';
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 28))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // SI recibimos filter, armamos el query
    if(isset($_GET['filter']) && $_GET['filter'] != ''){
        $filter = " AND (cmsusers.name LIKE '%".$_GET['filter']."%') ";
    }
    
    //Contamos la cantidad de roles existentes
    $sql = "SELECT count(id) AS qty FROM cmsusers WHERE type=0 ".
    "       ".$filter;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Guardamos el total de resultados existentes
    $row= $rs->fetch_assoc();
    $out->numofrecords = (int)$row["qty"];
    
    $sql = "SELECT id, name, status, rolid FROM cmsusers".
    "       WHERE type=0 ".
    "       ".$filter.
    "       ".$order.
    "       LIMIT ".$offset.",".$numofrecords;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    while($row = $rs->fetch_assoc()){
        
        $record = new stdClass();
        $record->id = (int)$row["id"];
        $record->user = $row["name"];
        
        $record->status = (int)$row["status"];
        $record->statusdsc = $record->status == 1 ? "Activo" : "Inactivo";
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    $out->privileges = new stdClass();
    $out->privileges->created = true;
    $out->privileges->read = true;
    $out->privileges->update = true;
    $out->privileges->delete = true;
        
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function determinateOrder($order){
        $str = '';
        
        switch($order){
            case 1:
                $str = ' ORDER BY name ASC';
                break;
            case -1:
                $str = ' ORDER BY name DESC';
                break;
            default:
                $str = ' ORDER BY id ASC';
        }
        
        return $str;
    }
?>