<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","schoolid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $schoolid = $_GET["schoolid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 1))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    $sql = "SELECT id, name, code, ".
        "       region, private,".
        "       email, contact,".
        "       phone, position, phonesecundary,".
        "       contactalt, positionalt,".
        "       modality, ".
        "       emailalt, phonealt, allowedpupils, ".
        "       asociations, ".
        "       estimatedpupilsedit".
        "       FROM schools ".
        "       WHERE id = ".$schoolid."";
        
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row= $rs->fetch_assoc();
    
    $out->id = $row["id"];
    $out->code = $row["code"];
    $out->name = $row["name"];
    $out->region = new stdClass();
    $out->region->name = $row["region"];
    $out->privat = ($row["private"] == 1 ? true : false);
    $out->email = $row["email"];
    $out->contact = $row["contact"];
    $out->phone = $row["phone"];
    $out->phonesecundary = $row["phonesecundary"];
    $out->positionalt = $row["positionalt"];
    $out->contactalt = $row["contactalt"];
    $out->emailalt = $row["emailalt"];
    $out->phonealt = $row["phonealt"];
    $out->position = $row["position"];
    $out->allowedpupils = (int)$row['allowedpupils'];
    
    $out->asociations = $row['asociations'];
    
    if ($row['modality'] == 1) {
        $out->modality = 'Online';
    } else if ($row['modality'] == 2) {
        $out->modality = 'Presencial';
    } else {
        $out->modality = '';
    }
        
    //Aqui se cambia el precio por alumno
    
    $out->price = new stdClass();
    $out->price->amount = 160000;
    
    // PRECIO POR ALUMNO
    $out->editlocked = ($row["estimatedpupilsedit"] == 1 ? true : false);
    
    //Cantidad de alumnos totales
    $out->estimatedpupils = new stdClass();
    
    $sql = "SELECT sum(qty) as qty FROM estimatedpupils WHERE schoolid=".$schoolid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $row= $rs->fetch_assoc();
    
    $out->estimatedpupils->quantity = $row["qty"];
    
    if($out->privat){
        $sql = "SELECT id, validated, ".
        "       account, date,".
        "       ref, rif, ".
        "       type, amount ".
        "       FROM payments ".
        "       WHERE schoolid = ".$schoolid." ";
    
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
    
        while($row = $rs->fetch_assoc()){
            
            $payment = new stdClass();
            $payment->id = $row["id"];
            $payment->validated = ($row["validated"] == 1 ? true : false);
            $payment->account = $row["account"];
    
            $payment->datepay = new stdClass();
            $dateFormat = strtotime($row["date"]);
            $payment->datepay->short = $row["date"];
            $payment->datepay->row = date("Y",$dateFormat).date("m",$dateFormat).date("d",$dateFormat);
            $payment->datepay->long = date("d",$dateFormat)." de ".getMonth(date("m",$dateFormat))." de ".date("Y",$dateFormat);
    
            $payment->ref = $row["ref"];
            $payment->rif = $row["rif"];
            $payment->type = new stdClass();
            $payment->type->id = $row["type"];
            $payment->type->dsc = determinateKindOp($payment->type->id);
            $payment->amount = new stdClass();
            $payment->amount->number = $row["amount"]; 
            $payment->amount->formatted = number_format($row["amount"], 2, ",", ".");
            
            $payments [] = $payment;
        }
        
        $out->payment = $payments;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function getMonth($mt){
        $month = "";
        
        switch ($mt) {
            case 1:
                $month = "Enero";
                break;
            case 2:
                $month = "Febrero";
                break;
            case 3:
                $month = "Marzo";
                break;
            case 4:
                $month = "Abril";
                break;
            case 5:
                $month = "Mayo";
                break;
            case 6:
                $month = "Junio";
                break;
            case 7:
                $month = "Julio";
                break;
            case 8:
                $month = "Agosto";
                break;
            case 9:
                $month = "Septiembre";
                break;
            case 10:
                $month = "Octubre";
                break;
            case 11:
                $month = "Noviembre";
                break;
            case 12:
                $month = "Diciembre";
                break;
        }
        return $month;
    }
    
    function determinateKindOp($id){
        $str = '';
        
        switch($id){
            case 1:
                $str = 'Mismo banco';
                break;
            case 2:
                $str = "Otro banco";
                break;
        }
        
        return $str;
    }
?>