<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","offset","numofrecords");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $offset = $_GET["offset"];
    $filter = "";
    $region = "";
    $type = "";
    $order = " ORDER BY id DESC";
    $status = "";
    $numofrecords = $_GET["numofrecords"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 1))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    if(isset($_GET["filter"]) && $_GET["filter"] != ""){
        $filter = " AND (name LIKE '%".$_GET["filter"]."%' OR ".
        "           code LIKE '%".$_GET["filter"]."%')";
    }
    
    if(isset($_GET["region"]) && $_GET["region"] != ""){
        $region = " AND region='".$_GET["region"]."' ";
    }
    
    if(isset($_GET["type"]) && $_GET["type"] != ""){
        $type = " AND private = '".$_GET["type"]."' ";
    }
    
    if(isset($_GET["status"]) && $_GET["status"] != ""){
        // 0 = Registrado
        // 1 = Registrado sin estimacion
        // 2 = registrado y estimando
        // 3 = Inscribiendo
        // 4 = Sin registrar
        if($_GET["status"] == 0){
            $status .= " AND email IS NOT NUll ";
        }else if($_GET["status"] == 1){
            $status .= " AND email IS NOT NUll AND estimatedpupilsedit = 1 ".
            "           AND (SELECT COUNT(estimatedpupils.id) AS qty FROM estimatedpupils WHERE estimatedpupils.schoolid = schools.id) = 0 ";
        }else if($_GET["status"] == 2){
            
            $status .= " AND email IS NOT NUll ".
            "           AND (SELECT COUNT(estimatedpupils.id) AS qty FROM estimatedpupils WHERE estimatedpupils.schoolid = schools.id) > 0 ".
            "           AND (SELECT COUNT(pupils.id) AS qty FROM pupils WHERE pupils.schoolid = schools.id) = 0 ";
        }else if($_GET["status"] == 3){
            $status .= " AND email IS NOT NULL ".
            "       AND (SELECT COUNT(pupils.id) AS qty FROM pupils WHERE pupils.schoolid = schools.id) > 0 ";
        }else if($_GET["status"] == 4){
            $status .= " AND email IS NUll  ";
        }
    }
    
    if(isset($_GET["order"]) && $_GET["order"] != ""){
        $order = " ORDER BY ".$_GET["order"];
    }
    
    if(isset($_GET["all"])){
        
        $order = "";    
        if(isset($_GET["order"]) && $_GET["order"] != ""){
            $order = " ORDER BY ".$_GET["order"];
        }
        
        $sql = "SELECT id, code, name, region FROM schools ".
        "       ".$order;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        
        
        
        $cont = 0;
        while($row = $rs->fetch_assoc()){
            $out->schools->records[$cont] = new stdClass();
            $out->schools->records[$cont]->id = (int)$row["id"];
            $out->schools->records[$cont]->code = (int)$row["code"];
            $out->schools->records[$cont]->name = $row["name"];
            $out->schools->records[$cont]->region = $row["region"];
            $out->schools->records[$cont]->access = "NO";
            $cont++;
        }
        
        header("HTTP/1.1 200");
        echo (json_encode($out));
        die();
    }
    
    //Contamos el total de resultados existentes
    $sql = "SELECT COUNT(id) AS totally".
    "       FROM schools".
    "       WHERE id IS NOT NULL". //email IS NOT NULL AND hashregister IS NULL".
    "       ".$filter.
    "       ".$region.
    "       ".$type.
    "       ".$status;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Guardamos el total de resulTados existentes
    $row = $rs->fetch_assoc();
    $number = $row["totally"];
    //Verificamos si necesitamos usar limit y colocar las vueltas del ciclo
    if( $offset != "null" && $numofrecords!= "null" ){
        $limit = "LIMIT ".$offset.",".$numofrecords." ";
        $count = $numofrecords;
    }else{
        $count = $number;
    }
    
    $out->numofrecords = (int)$number;
    
    //Buscamos los datos detallados
    $sql = "SELECT id,code,name,region, ".
    "       private,estimatedpupilsedit, ".
    "       contact,position,phone,email, ".
    "       phonesecundary,contactalt,positionalt, ".
    "       modality, ".
    "       asociations, ".
    "       CASE ".
    "           WHEN email IS NOT NULL AND estimatedpupilsedit = 1 ".
    "               AND (SELECT COUNT(estimatedpupils.id) AS qty FROM estimatedpupils WHERE estimatedpupils.schoolid = schools.id) = 0 THEN 'Registrado sin estimación' ".
    "           WHEN email IS NOT NULL ".
    "               AND (SELECT COUNT(estimatedpupils.id) AS qty FROM estimatedpupils WHERE estimatedpupils.schoolid = schools.id) > 0 ".
    "               AND (SELECT COUNT(pupils.id) AS qty FROM pupils WHERE pupils.schoolid = schools.id) = 0 THEN 'Registrado y estimando' ".
    "           WHEN email IS NOT NULL ".
    "               AND (SELECT COUNT(pupils.id) AS qty FROM pupils WHERE pupils.schoolid = schools.id) > 0 THEN 'Inscribiendo' ".
    "           ELSE 'No registrado' ".
    "       END AS status, ".
    "       phonealt,emailalt".
    "       FROM schools".
    "       WHERE id IS NOT NULL ".//email IS NOT NULL AND ".
    "       ".$filter.
    "       ".$region.
    "       ".$type.
    "       ".$status.
    "       ".$order.
    "       ".$limit;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        $record->id = $row["id"];
        $record->code = $row["code"];
        $record->name = $row["name"];
        $record->region = new stdClass();
        $record->region->name = $row["region"];
        $record->type = new stdClass();
        $record->type->id = $row["private"];
        $record->type->dsc = $row["private"] == 0 ? "Oficial" : "Privado";
        
        $record->status = new stdClass();
        $record->status->id = $row["estimatedpupilsedit"] == 1 ? 2 : 3;
        $record->status->dsc = $row['status'];
        
        $record->contact = $row["contact"];
        $record->position = $row["position"];
        $record->phone = $row["phone"];
        $record->phonesecundary = $row['phonesecundary'];
        $record->email = $row["email"];
        $record->contactalt = $row["contactalt"];
        $record->positionalt = $row["positionalt"];
        $record->emailalt = $row["emailalt"];
        $record->phonealt = $row["phonealt"];
        
        
        if ($row['modality'] == 1) {
            $record->modality = 'Online';
        } else if ($row['modality'] == 2) {
            $record->modality = 'Presencial';
        } else {
            $record->modality = '';
        }
        
        $record->asociations = $row['asociations'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    $parmsob = array("csv");
    if (parametrosValidos($_GET, $parmsob)){
        //eliminar documentos anteriores
        $files = glob('exports/*');
        foreach($files as $file){
            if(is_file($file))
                unlink($file);
        }
        
        $head = array("CÓDIGO",
        "NOMBRE DEL COLEGIO",
        "REGIÓN",
        "TIPO",
        "CONTACTO",
        "POSICIÓN",
        "CORREO",
        "TELÉFONO",
        "TELÉFONO SECUNDARIO",
        "CONTACTO ALT.",
        "POSICIÓN ALT.",
        "EMAIL ALT.",
        "TELÉFONO ALT.",
        "STATUS",
        "MODALIDAD",
        "AGRUPACIÓN");
        
        for($i = 0; $i < $number; $i++){
            $lista [] = array(
                $out->records[$i]->code,
                $out->records[$i]->name,
                $out->records[$i]->region->name,
                $out->records[$i]->type->dsc,
                $out->records[$i]->contact,
                $out->records[$i]->position,
                $out->records[$i]->email,
                $out->records[$i]->phone,
                $out->records[$i]->phonesecundary,
                $out->records[$i]->contactalt,
                $out->records[$i]->positionalt,
                $out->records[$i]->emailalt,
                $out->records[$i]->phonealt,
                $out->records[$i]->status->dsc,
                $out->records[$i]->modality,
                $out->records[$i]->asociations,
                );
        }

        $fp = fopen('exports/school_data.csv', 'wb');
        fwrite($fp, $BOM);
        $head = array_map("utf8_decode", $head);
        fputcsv($fp, $head, ";", '"');

        foreach ($lista as $campos) {
            $campos = array_map("utf8_decode", $campos);
            fputcsv($fp, $campos, ';');
        }

        fclose($fp);
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>