<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("sessionid",'offset','numofrecords');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    // Declaracion e inicializacion de variables
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $offset = $_GET['offset'];
    $numofrecords = $_GET['numofrecords'];
    $order = '';
    $filter = '';
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    // SI recibimos el filter, armamos el query
    if(isset($_GET['filter']) && $_GET['filter']){
        $filter = " WHERE (".
        "       name LIKE '%".$_GET['filter']."%' ".
        "       OR content LIKE '%".$_GET['filter']."%'".
        "       )";
    }
    
    // SI recibimos el order, armamos el query
    if(isset($_GET['order']) && $_GET['order']){
        $order = " ORDER BY ".$_GET['order'];
    }
    
    // Consultamos la cantidad de registros que existen
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM settings".
    "       ".$filter;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    // Retornamos la cantidad de registros
    $out->numofrecords = (int)$row['qty'];
    
    $sql = "SELECT * FROM settings".
    "       ".$filter.
    "       ".$order;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    while($row = $rs->fetch_assoc()){
        $record = new stdClass();
        
        $record->id = (int)$row['id'];
        $record->name = $row['name'];
        $record->type = (int)$row['type'];
        $record->support = $row['support'];
        $record->content = $row['content'];
        $record->dsc = $row['dsc'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>