<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    //Parametros obligatorios
    $parmsob = array("sessionid",'id','name','type','support','content');
    if (!parametrosValidos($_POST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    // Declaracion e inicializacion de variables
    $out = new stdClass();
    $sessionid = $_POST["sessionid"];
    $id = $_POST['id'];
    $name = $_POST['name'];
    $type = $_POST['type'];
    $support = $_POST['support'];
    $content = $_POST['content'];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 44))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    // Validamos que exista
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM settings ".
    "       WHERE id = ".$id;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    if($row['qty'] == 0){
        badEnd(204,array('msg'=>'Registro no encontrado'));
    }
    
    //Actualizamos el dato
    $sql = "UPDATE settings SET ".
    "       name = '".$name."', ".
    "       type = '".$type."', ".
    "       support = '".$support."', ".
    "       content = '".$content."' ".
    "       WHERE id = ".$id;
    if (!$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $out->id = (int)$id;
    
    setAudit($db, "PREFERENCIAS", $sessionid, "Se actualizo la preferencia ".$name.($type == 1 || $type == 2 ? " con ".$content : ''));
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>