<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Obtendremos la cantidad de regiones existentes
    $sql = "SELECT COUNT(DISTINCT corrector) AS totally FROM corrections";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row= $rs->fetch_array();
    $out->numofrecord = $row["totally"];
    
    //Obtenemos las regiones que se encuentran en la BD
    $sql = "SELECT DISTINCT corrector AS id FROM corrections ORDER BY corrector";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    while($row = $rs->fetch_array()){
        $record = new stdClass();
        $record->id = (int)$row['id'];
        
        // Obtenemos el nombre del profesor
        $sql = "SELECT name FROM cmsusers WHERE id = ".$record->id;
        if (!$res=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
            
        $rowU = $res->fetch_array();
        $record->name = $rowU['name'];
        
        $records [] = $record;
    }
    
    $out->records = $records;
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>