<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","filename");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
        
    $sessionid = $_GET["sessionid"];
    $filename = $_GET["filename"];
    
    $out = new stdClass();
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 42))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    $files = glob('../.'.$filename);
    if(sizeof($files) > 0){
        try{
            unlink($files[0]);
            $out->filename=basename($files[0]);
        }catch(Exception $e){
            badEnd("304", array("msg"=>"No se puede borrar" . implode(", ", $parmsob)));
        }
        
    }else{
        badEnd("204", array("msg"=>"No se encuentra el registro" . implode(", ", $parmsob)));
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>