<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    // Parametros obligatorios
    $parmsob = array("sessionid",'level');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    // Declaracion de variables
    $out = new stdClass(); 
    $out->entry = new stdClass();
    $sessionid = $_GET['sessionid'];
    $level = $_GET['level'];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 34))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //COnsultamos que exista el examen
    $sql = "SELECT COUNT(id) AS qty ".
    "       FROM tests ".
    "       WHERE level = ".$level;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    // SI es 0 el registro no existe
    if($row['qty'] == 0 ){
        badEnd('404',array("msg"=>'Registro no encontrado'));
    }
    
    // Consultamos el registro
    $sql = "SELECT * ".
    "       FROM tests ".
    "       WHERE level = ".$level;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    $row = $rs->fetch_assoc();
    
    // Retornamos los datos
    $out->entry->id = (int)$row['id'];
    $out->entry->name = $row['name'];
    
    $out->entry->level = new stdClass();
    $out->entry->level->id = (int)$row['level'];
    $out->entry->level->dsc = $row['level'].abrev($level)." Grado";
    
    // Recorremos todas las respuestas con su dificultas etc
    for($i = 1; $i <= 30; $i++){
        $anwser [] = $row["q".$i] == null ? null : (int)$row["q".$i];
        
        $diff [] = $row['dif'.$i] == null ? null : (int)$row['dif'.$i];
        
        $components [] = $row['comp'.$i] == null ? null : (int)$row['comp'.$i];
        
        $competencies [] = $row['compet'.$i] == null ? null : (int)$row['compet'.$i];
    }
    
    $out->entry->references = $anwser;
    $out->entry->dificulty = $diff;
    $out->entry->components = $components;
    $out->entry->competencies = $competencies;
    
    $out->entry->points = new stdClass();
    $out->entry->points->initial = (float)$row['ptsini'];
    
    $out->entry->points->good = new stdClass();
    $out->entry->points->good->low = (float)$row['ptsoklow'];
    $out->entry->points->good->mid = (float)$row['ptsokmid'];
    $out->entry->points->good->high = (float)$row['ptsokhigh'];
    
    $out->entry->points->bad = new stdClass();
    $out->entry->points->bad->low = (float)$row['ptsbadlow'];
    $out->entry->points->bad->mid = (float)$row['ptsbadmid'];
    $out->entry->points->bad->high = (float)$row['ptsbadhigh'];
    
    $out->entry->points->blank = (int)$row['ptsblank'];
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function abrev($level){
        return $level == "3" || $level == "1" ? "ro" : ($level == "2" ? "do" : "to");
    }
?>