<?php 
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    // Parametros obligatorios
    $parmsob = array("sessionid",'testid','level','ptsini','ptsoklow','ptsokmid','ptsokheight','ptsbadlow','ptsbadmid','ptsbadhigh','ptsblank');
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    // Declaracion de variables
    $out = new stdClass(); 
    $sessionid = $_GET['sessionid'];
    $testid = $_GET['testid'];
    $level = $_GET['level'];
    $ptsini = $_GET['ptsini'];
    $ptsoklow = $_GET['ptsoklow'];
    $ptsokmid = $_GET['ptsokmid'];
    $ptsokhigh = $_GET['ptsokheight'];
    $ptsbadlow = $_GET['ptsbadlow'];
    $ptsbadmid = $_GET['ptsbadmid'];
    $ptsbadhigh = $_GET['ptsbadhigh'];
    $ptsblank = $_GET['ptsblank'];
    $numberQty = 30;
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 35))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    //Si el testid es 0, significa que debemos insertar la prueba, si no actualizamos
    if(intval($testid) == 0){
        
        // Insertamos el examen
        $sql = "INSERT INTO tests(".
        "       name, level, ".
        "       ptsini, ptsblank, ".
        "       ptsoklow, ptsokmid, ".
        "       ptsokhigh, ptsbadlow, ".
        "       ".createQueryInsertLabel('q', $numberQty, $_GET).
        "       ".createQueryInsertLabel('dif', $numberQty, $_GET).
        "       ".createQueryInsertLabel('comp', $numberQty, $_GET).
        "       ".createQueryInsertLabel('compet', $numberQty, $_GET).
        "       ptsbadmid, ptsbadhigh ".
        "       ) ".
        "       VALUES(".
        "       'Prueba Preliminar', ".$level.", ".
        "       ".$ptsini.", ".$ptsblank.", ".
        "       ".$ptsoklow.", ".$ptsokmid.", ".
        "       ".$ptsokhigh.", ".$ptsbadlow.", ".
        "       ". createQueryInsertValue('q', $numberQty, $_GET).
        "       ". createQueryInsertValue('dif', $numberQty, $_GET).
        "       ". createQueryInsertValue('comp', $numberQty, $_GET).
        "       ". createQueryInsertValue('compet', $numberQty, $_GET).
        "       ".$ptsbadmid.", ".$ptsbadhigh.
        "       )";
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $out->id = (int)$db->insert_id;
        $out->level = (int)$level;
    }else{
        
        // Validamos que el test id
        $sql = "SELECT COUNT(id) AS qty ".
        "       FROM tests ".
        "       WHERE id = ".$testid;
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error));
        
        $row = $rs->fetch_assoc();
        
        // SI no existe retornamos error
        if($row['qty'] == 0){
            badEnd("404",array('msg'=>'Registro no encontrado'));
        }
        
        //Actualizamos el examen
        $sql = "UPDATE tests SET ".
        "       ptsini = ".$ptsini.", ".
        "       ptsblank = ".$ptsblank.", ".
        "       ptsoklow = ".$ptsoklow.", ".
        "       ptsokmid = ".$ptsokmid.", ".
        "       ptsokhigh = ".$ptsokhigh.", ".
        "       ptsbadlow = ".$ptsbadlow.", ".
        "       ".createQueryUpdate('q', $numberQty, $_GET).
        "       ".createQueryUpdate('dif', $numberQty, $_GET).
        "       ".createQueryUpdate('comp', $numberQty, $_GET).
        "       ".createQueryUpdate('compet', $numberQty, $_GET).
        "       ptsbadmid = ".$ptsbadmid.", ".
        "       ptsbadhigh = ".$ptsbadhigh." ".
        "       WHERE id = ".$testid.
        "       AND level = ".$level;
        if (!$db->query($sql))
            badEnd("500", array("msg"=>$db->error.$sql));
            
        $out->id = (int)$testid;
        $out->level = (int)$level;
    }
    
    setAudit($db, "PREFERENCIAS", $sessionid, "Se actualizaron las preferencias del examen para el grado ".$level);
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
    
    function createQueryInsertLabel($label, $numbers, $POST){
        $str = '';
        
        for($i = 0; $i < $numbers; $i++){
            $str .= validParam($POST, $label.($i+1)) ? $label.($i+1).", " : '';
        }
        
        return $str;
    }
    
    function createQueryInsertValue($label, $numbers, $POST){
        $str = '';
        
        for($i = 0; $i < $numbers; $i++){
            $str .= validParam($POST, $label.($i+1)) ? $POST[$label.($i+1)].", " : '';
        }
        
        return $str;
    }
    
    function createQueryUpdate($label, $numbers, $POST){
        $str = '';
        
        for($i = 0; $i < $numbers; $i++){
            $str .= validParam($POST, $label.($i+1)) ? $label.($i+1)." = ".$POST[$label.($i+1)].", " : '';
        }
        
        return $str;
    }
    
    function validParam($POST, $label){
        if(isset($POST[$label]) && $POST[$label] != ''){
            return true;
        }
        
        return false;
    }
?>