<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    $parmsob = array("sessionid","offset","numofrecords");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros invalidos " . implode(", ", $parmsob)));
    
    $out = new stdClass();
    $sessionid = $_GET["sessionid"];
    $offset = $_GET["offset"];
    $filter = "";
    $order = "";
    $region = "";
    $numofrecords = $_GET["numofrecords"];
    
    //Verificamos que la sesion no este expirada
    isSessionValid($db, $sessionid);
    
    //Validamos que el usuario tenga privilegios
    if(!tienePrivilegio($db, $sessionid, 24))
        badEnd("403", array("msg"=>"No tiene Privilegios"));
    
    if(isset($_GET["order"]) && $_GET["order"]){
        $order = " ORDER BY ".$_GET["order"];
    }
    
    if(isset($_GET['region']) && $_GET['region']){
        $region = " AND schools.region = '".$_GET['region']."' ";
    }
    
    if(isset($_GET["filter"]) && $_GET["filter"]){
        $filter = " AND (cmsusers.name LIKE '%".$_GET["filter"]."%' OR cmsusers.email LIKE '%".$_GET["filter"]."%') ";
    }
    
    //Contamos el total de resultados existentes
    $sql = "SELECT COUNT(cmsusers.id) AS totally".
    "       FROM cmsusers ".
    "       LEFT JOIN schools ON cmsusers.schoolid = schools.id ".
    "       WHERE cmsusers.type = 1 ".
    "       ".$region.
    "       ".$filter;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
    //Guardamos el total de resultados existentes
    $row = $rs->fetch_assoc();
    $out->numofrecords = (int)$row["totally"];
    
    //Obtenemos todos los datos requeridos
    $sql = "SELECT cmsusers.id AS idUser, cmsusers.email AS emailUser, cmsusers.name AS nameUser, validthru AS loginUser,".
    "       cmsusers.status AS statusUser, cmsusers.rolid as role, schools.name AS nameSchool,".
    "       schools.region AS regionSchool, schools.id AS idSchool".
    "       FROM cmsusers ".
    "       LEFT JOIN schools ON cmsusers.schoolid = schools.id ".
    "       WHERE cmsusers.type = 1 ".
    "       ".$region.
    "       ".$filter.
    "       ".$order.
    "       LIMIT ".$offset.",".$numofrecords;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
        
        
    for($i = 0; $i < $numofrecords; $i++){
        $row = $rs->fetch_assoc();
        
        $out->records[$i] = new stdClass();
        $out->records[$i]->id = (int)$row["idUser"];
        $out->records[$i]->user = $row["nameUser"];
        $out->records[$i]->name = $row["nameUser"];
        $out->records[$i]->email = $row["emailUser"];
        $out->records[$i]->login = $row["loginUser"];
        
        $out->records[$i]->status = new stdClass();
        $out->records[$i]->status->id = (int)$row["statusUser"];
        $out->records[$i]->status->dsc = $out->records[$i]->status->id == 1 ? "Activo" : "Inactivo";
        
        $out->records[$i]->hola = $row;
        if($row['role'] == null){
            $out->records[$i]->rol = null;
        }else{
            //COnsultamos el rol que poseemos
            $sql = "SELECT * FROM cmsusers ".
            "       WHERE id = ".$row['role'].
            "       AND type = 0";
            if (!$res=$db->query($sql))
                badEnd("500", array("msg"=>$db->error));
            
            $rowRol = $res->fetch_assoc();
            
            $out->records[$i]->rol = new stdClass();
            $out->records[$i]->rol->id = (int)$rowRol['id'];
            $out->records[$i]->rol->roldsc = $rowRol['name'];
            
            $out->records[$i]->rol->rolmodified = false;
        }
        
        $out->records[$i]->school = new stdClass();
        $out->records[$i]->school->id = $row["idSchool"] == null ? '' : (int)$row["idSchool"];
        $out->records[$i]->school->name = $row["nameSchool"] == null ? '' : $row["nameSchool"];
        $out->records[$i]->school->region = $row["regionSchool"] == null ? '' : $row["regionSchool"];
        
        $out->records[$i]->privileges = new stdClass();
        $out->records[$i]->privileges->created = true;
        $out->records[$i]->privileges->read = true;
        $out->records[$i]->privileges->update = true;
        $out->records[$i]->privileges->delete = true;
    }
    
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>