var located = new URLSearchParams(location.search);
var qtyForPage = 10;
var like = located.get('like') === 'null' || located.get('like') === null ? '' : located.get('like');
var order = located.get('order') === 'null' || located.get('order') === null ? 'pupils.id' : located.get('order');
var page = located.get("page") === null ? 1 : parseInt(located.get("page"));
var numPages;
var level = located.get('level') === 'null' || located.get('level') === null  ? '' : located.get('level');
var region = located.get('region') === 'null' || located.get('region') === null  ? '' : located.get('region');
var schoolid = located.get('schoolid') === 'null' || located.get('schoolid') === null  ? '': located.get('schoolid');
var schooltype = located.get('schooltype') === 'null' || located.get('schooltype') === null  ? '': located.get('schooltype');
var testname = located.get('testname') === 'null' || located.get('testname') === null  ? '': located.get('testname');
var modalidad = located.get('modalidad') === 'null' || located.get('modalidad') === null  ? '' : located.get('modalidad');

var numOfRecords = 0;

window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    like = localStorage.getItem('like') === null ? '' : localStorage.getItem('like');
    order = localStorage.getItem('order') === null ? 'pupils.id' : localStorage.getItem('order');
    level = localStorage.getItem('level') === null ? '' : localStorage.getItem('level');
    region = localStorage.getItem('region') === null ? '' : localStorage.getItem('region');
    schoolid = localStorage.getItem('schoolid') === null ? '' : localStorage.getItem('schoolid');
    schooltype = localStorage.getItem('schooltype') === null ? '' : localStorage.getItem('schooltype');
    testname = localStorage.getItem('testname') === null ? '' : localStorage.getItem('testname');
    modalidad = localStorage.getItem('modalidad') === null ? '' : localStorage.getItem('modalidad');
    
    document.getElementById('searchInput').value = like;
    document.getElementById('levelStudent').value = level;
    
    let currentLocation = document.getElementsByClassName('tests') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    document.getElementsByClassName('modalidad')[0].value = modalidad;
    document.getElementsByClassName('res')[0].value = testname;
    document.getElementsByClassName('kind')[0].value = schooltype;
    
    let paramsListSchools = {
        offset: 0,
        filter: '',
        schoolid: schoolid,
        region: region,
        sessionid: located.get('ssid'),
        status: '',
        numofrecords: null,
        order: "id",
    };
    
    callListOfSchoolFirst(paramsListSchools);
}

function callListOfSchoolFirst(paramsList){
    callWS("GET", "schools/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            putSchools(json.records);
            
            var paramsListTest = {
                filter: like,
                regionid: region,
                level: level,
                offset: (page - 1) * qtyForPage,
                sessionid: located.get('ssid'),
                schoolid: schoolid,
                schooltype: schooltype,
                test: testname,
                kindTests: modalidad,
                numofrecords: qtyForPage,
                order: order,
                schoolid: schoolid,
            };
        
            callListOfTestFirst(paramsListTest);
    
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callListOfSchool(paramsList){
    callWS("GET", "schools/list", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            console.log('ok');
            putSchools(json.records);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callListOfTestFirst(paramsList){
    
    callWS("GET", "tests/listreaded", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        if (status == 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            numPages = Math.ceil(json.numofrecords/10);
            putValues(json);
            numOfRecords = json.numofrecords;
            document.getElementById('totalBox').style.display = 'block';
            document.getElementById('totalItems').innerHTML = `Total: ${format(numOfRecords.toString())}`;
            
             var params = {
                sessionid: located.get('ssid'),
                offset: 0,
            };
        
            callRegionFirst(params);
            
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            gotoTop();
            
            /*setTimeout(() => {
                msg.style.display="none";
            },5000)*/
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callListOfTest(paramsList){
    
    callWS("GET", "tests/listreaded", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        if (status == 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            numPages = Math.ceil(json.numofrecords/10);
            putValues(json);
            numOfRecords = json.numofrecords;
            document.getElementById('totalBox').style.display = 'block';
            document.getElementById('totalItems').innerHTML = `Total: ${format(numOfRecords.toString())}`;
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            gotoTop();
            
            /*setTimeout(() => {
                msg.style.display="none";
            },5000)*/
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callRegionFirst(paramsList){
    callWS("GET", "regions/list", paramsList, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            let json = JSON.parse(respText);
            putRegions(json.records);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function callRegion(paramsList){
    callWS("GET", "regions/list", paramsList, respxList);
    
    function respxList(status, respText){
        if (status == 200){
            let json = JSON.parse(respText);
            putRegions(json.records);
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function putRegions(records){
    let select = document.getElementsByClassName("region")[0];
    for(let i = 0; i< records.length; i++){
        let option = document.createElement("option");
        option.text = records[i].region;
        option.value = records[i].region;
        
        if(region == records[i].region){
            option.selected = true;
        }
        select.add(option);
    }
    
    document.getElementById('regionList').value = region;
}

function putValues(json){
    if(json.numofrecords == 0){
        alert("No existen registros");
    }else{
        for(let i = 0; i < json.records.length; i++){
            if(json.records[i].pupil.name !== null ){
                document.getElementsByClassName('testTable')[0].insertRow(-1).innerHTML = `
                <td>${json.records[i].pupil.code}</td>
                <td>${json.records[i].pupil.name + " " + json.records[i].pupil.surname}</td>
                <td>${json.records[i].pupil.gender.dsc}</td>
                <td>${json.records[i].pupil.level}${abrev(json.records[i].pupil.level)} ${json.records[i].pupil.section}</td>
                <td>${json.records[i].school.name}</td>
                <td>${json.records[i].school.region}</td>
                <td>${json.records[i].qualification}</td>
                <td><i class="eye ${json.records[i].qualification === "--" ? '' : 'eyePointer'}" 
                onclick="${json.records[i].qualification === "--" ? '' : 'navigateDetails('+json.records[i].pupil.id+')'}">
                ${json.records[i].qualification === "--" ? '<div class="lineEye"></div>' : ''}</i></td>`;
            }
        }
        makeNumbers();
    }
}
    
function navigateDetails(id){
    var located = new URLSearchParams(location.search);
    
    let params = {
        ssid: located.get('ssid'),
        n: located.get('n'),
        pupilid: id,
    }
    
    gotoPage('home', 'testInfo',params);
}

const abrev = level => {
    return level == "3" || level == "1" ? "ro" : (level == "2" ? "do" : "to");
}

const makeNumbers = () => {
    var container = document.getElementsByClassName('listPages')[0];
    var linkers = "";
    let interations = numPages > 10 ? 10 : numPages;
    for(let i = 0; i < interations; i++){
        if(numPages == 1){
            linkers += `<li><a href='javascript:paginationNavigate(${i+1})' class="pagination" id="${i+1}">${i+1}</a></li>`;
        }else if(page+i <= numPages){
            if(i === 0){
                linkers +=`<li><a href='javascript:paginationNavigate(${1})' class="pagination"><<</a></div>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${page === 1 ? 1 : page-1})' class="pagination"><</a></li>`;
                linkers += page === 1 ? '' : `<li><a href='javascript:paginationNavigate(${page-1})' class="pagination" id="${page-1}">${page-1}</a></li>`;
                linkers += `<li><a href='javascript:paginationNavigate(${page})' class="pagination" id="${page}">${page}</a></li>`;
            }else if(i == interations-1){
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="${page+i}">${page+i}</a></li>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${page === numPages ? numPages : page + 1})' class="pagination">></a></li>`;
                linkers +=`<li><a href='javascript:paginationNavigate(${numPages})' class="pagination">>></a></li>`;
            }else{
                linkers += `<li><a href='javascript:paginationNavigate(${page+i})' class="pagination" id="${page+i}">${page+i}</a></li>`;
            }
        }
    }
    container.innerHTML = linkers;
    document.getElementById(`${page}`).style.color = '#F68E1E';
}

function paginationNavigate(page){
    let located = new URLSearchParams(location.search);
    var params = {
        ssid: located.get('ssid'),
        n: located.get('n'),
        page: page,
    }
    
    if(order !== ""){
        params.order = order;
        localStorage.setItem('order', order);
    }
    
    if(like !== ""){
        params.like = like;
        localStorage.setItem('like', like);
    }
    
    if(region !== ""){
        params.region = region;
        localStorage.setItem('region', region);
    }
    
    if(schoolid !== ""){
        params.schoolid = schoolid;
        localStorage.setItem('schoolid', schoolid);
    }
    
    if(level !== ""){
        params.level = level;
        localStorage.setItem('level', level);
    }
    
    if(schooltype !== ""){
        params.schooltype = schooltype;
        localStorage.setItem('schooltype', schooltype);
    }
    
    if(testname !== "" ){
        params.testname = testname;
        localStorage.setItem('testname', testname);
    }
    
    if(modalidad !== "" ){
        params.modalidad = modalidad;
        localStorage.setItem('modalidad', modalidad);
    }
    
    gotoPage('home','searchTest',params);
}

function searchingPupil(e){
    if(e.keyCode == 13){
        var located = new URLSearchParams(location.search);
        
        like = e.target.value === "" ? '' : `${e.target.value}`;
        page = 1;
        localStorage.setItem('like', like);
        
        var paramsList = {
            filter: like,
            regionid: region,
            level: level,
            offset: (page - 1) * qtyForPage,
            sessionid: located.get('ssid'),
            schoolid: schoolid,
            schooltype: schooltype,
            kindTests: modalidad,
            test: testname,
            numofrecords: qtyForPage,
            order: order,
        };
        
        var table = document.getElementsByClassName("testTable")[0].rows;
        var rowCount = table.length;
    
        for(let i = rowCount - 1; i > 0; i--){
            table[i].closest('tr').remove();
        }
    
        callListOfTest(paramsList);
    }
}

function searchFilter(e) {
    let located = new URLSearchParams(location.search);

    if(e.target.className === "region"){
        region = e.target.value;
        localStorage.setItem('region', region);
        
        document.getElementById("inputSchools").value = "";
        
        schoolid='';
        let paramsSchool = {
            region: region,
            schoolid: schoolid,
            type: schooltype,
            offset: 0,
            sessionid: located.get('ssid'),
            status: '',
            numofrecords: null,
            order: "id",
        }
        
        callListOfSchool(paramsSchool);
    }
    
    if(e.target.className === "grade"){
        level = e.target.value;
        localStorage.setItem('level', level);
    }
    
    if(e.target.className === "kind"){
        schooltype = e.target.value;
        localStorage.setItem('schooltype', schooltype);
        
        document.getElementById("inputSchools").value = "";
        
        schoolid='';
        let paramsSchool = {
            region: region,
            schoolid: schoolid,
            type: schooltype,
            offset: 0,
            sessionid: located.get('ssid'),
            status: '',
            numofrecords: null,
            order: "id",
        }
        
        callListOfSchool(paramsSchool);
    }
    
    if(e.target.className === "res"){
        testname = e.target.value;
        localStorage.setItem('testname', testname);
    }
    
    if(e.target.className === "schools" && e.target.value != ""){
        let getId = e.target.value.split("-");
        console.log(getId.length);
        if(getId.length < 2){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Debe seleccionar un colegio";
            setTimeout(() => {
                msg.style.display="none";
            },5000);
            return 0;
        }
        schoolid = getId[0];
        localStorage.setItem('schoolid', schoolid);
    }else if(e.target.className === "schools" && e.target.value == ""){
        schoolid='';  
        localStorage.setItem('schoolid', schoolid);
    }
    
    if(e.target.className === "modalidad"){
        modalidad = e.target.value;
        localStorage.setItem('modalidad', modalidad);
    }
    
    page = 1;
        
    var paramsList = {
        filter: like,
        regionid: region,
        level: level,
        offset: (page - 1) * qtyForPage,
        sessionid: located.get('ssid'),
        schoolid: schoolid,
        kindTests: modalidad,
        schooltype: schooltype,
        test: testname,
        numofrecords: qtyForPage,
        order: order,
    };
    
    var table = document.getElementsByClassName("testTable")[0].rows;
    var rowCount = table.length;
    for(let i = rowCount - 1; i > 0; i--){
         table[i].closest('tr').remove();
    }
        
    callListOfTest(paramsList);
}

function changeOrder(event){
    var located = new URLSearchParams(location.search);
    
    var arrowsUp = document.getElementsByClassName('up');
    var arrowsDown = document.getElementsByClassName('down');
    
    var paramsList = {
        filter: like,
        regionid: region,
        level: level,
        offset: (page - 1) * qtyForPage,
        sessionid: located.get('ssid'),
        schoolid: schoolid,
        kindTests: modalidad,
        schooltype: schooltype,
        test: testname,
        numofrecords: qtyForPage,
        order: order,
    };
    
    for(let i = 0; i< arrowsUp.length; i++){
        arrowsDown[i].setAttribute('onclick','changeOrder(this)');
        arrowsUp[i].setAttribute('onclick','changeOrder(this)');
        
        arrowsDown[i].style.borderColor = "#FFF";
        arrowsUp[i].style.borderColor = "#FFF";
        arrowsDown[i].style.cursor = "pointer";
        arrowsUp[i].style.cursor = "pointer";
    }
    
    var arrow = document.getElementById(event.id);
    arrow.setAttribute('onclick','');
    arrow.style.cursor = "auto";
    arrow.style.borderColor = "#BBB";
    
    switch(event.id){
        case "codeUp":
            order = "pupils.id ASC";
            break;
        case "codeDown":
            order = "pupils.id DESC";
            break;
        case "nameUp":
            order = "pupils.name ASC";
            break;
        case "nameDown":
            order = "pupils.name DESC";
            break;
        case "genderUp":
            order = "pupils.gender ASC";
            break;
        case "genderDown":
            order = "pupils.gender DESC";
            break;
        case "gradeUp":
            order = "pupils.level ASC, pupils.section ASC";
            break;
        case "gradeDown":
            order = "pupils.level DESC, pupils.section DESC";
            break;
        case "collegeUp":
            order = "schools.name ASC";
            break;
        case "collegeDown":
            order = "schools.name DESC";
            break;
        case "regionUp":
            order = "schools.region ASC";
            break;
        case "regionDown":
            order = "schools.region DESC";
            break;
        case "pointUp":
            order = "answers.id ASC";
            break;
        case "pointDown":
            order = "answers.id DESC";
            break;
        case "resultUp":
            order = " score ASC";
            break;
        case "resultDown":
            order = " score DESC";
            break;
    }
    
    paramsList.order = order;
    localStorage.setItem('order', order);
    
    var table = document.getElementsByClassName("testTable")[0].rows;
    var rowCount = table.length;
    
    for(let i = rowCount - 1; i > 0; i--){
        table[i].closest('tr').remove();
    }
    
    callListOfTest(paramsList);
}

function putSchools(records){
    let option = "";
    option += `<option disabled selected>Colegios...</option>`;
    option += `<option value="">TODOS</option>`;
    for(let i = 0; i < records.length; i++){
        option += `<option value="${records[i].id} - ${records[i].name}">${records[i].id} - ${records[i].name}</option>`;
        
        if(parseInt(records[i].id) == parseInt(schoolid)){
            document.getElementById('inputSchools').value = `${records[i].id} - ${records[i].name}`;
        }
        
    }
    
    document.getElementById("schools").innerHTML = option;
}

function exportTableToExcel(){
    let paramsList = {
        filter: like,
        region: region,
        schoolid: schoolid,
        level: level,
        schooltype: schooltype,
        test: testname,
        kindTests: modalidad,
        offset: 0,
        numofrecords: parseInt(numOfRecords),
        order: `pupils.id ASC`,
        sessionid: located.get('ssid'),
        csv: 1
    };
    
    callWS("GET", "tests/listreadedcsv", paramsList, respxList);

    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        var json = JSON.parse(respText);
        if (status == 200){
            loadScreen();
            downloadCsv();
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

function downloadCsv() {
    let linkPhp = document.createElement("a");
    linkPhp.href = globalurl + "/api/tests/exports/TODOS.csv";
    linkPhp.download = "TODOS.csv";
    document.body.appendChild(linkPhp);
    linkPhp.click();
    document.body.removeChild(linkPhp);
    closeLoad();
}

function format(input) {
    var num = input.replace(/\./g,'');
    num = num.toString().split('').reverse().join('').replace(/(?=\d*\.?)(\d{3})/g,'$1.');
    num = num.split('').reverse().join('').replace(/^[\.]/,'');
    
    return num;
}