window.onload = function carga() {
    
    var located = new URLSearchParams(location.search);
    
    let currentLocation = document.getElementsByClassName('configuration') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    // Obtenemos las preferencias
    loadSettings(located.get('ssid'), 0 ,30);
}

function loadSettings(sessionid, offset, numofrecords){
    var params = {
        sessionid: sessionid,  
        offset: offset,
        numofrecords: numofrecords,
    };
        
    callWS("GET", "settings/list", params, respxList);
    
    function respxList(status, respText){
        console.log(status);
        switch(status){
            case 200:
                console.log(JSON.parse(respText));
                var json = JSON.parse(respText);
                buildForm(json);
                break;
            case 403:
                var msg = document.getElementById('error');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                gotoTop();
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            case 500:
                var msg = document.getElementById('error');
                msg.style.display="block";
                msg.innerHTML = "Error interno";
                gotoTop();
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
        }
    }
}

function buildForm(dataArr){
    // REcorremos los records
    document.getElementById('formBox').innerHTML = '';
    dataArr.records.forEach((el, index) => {
        console.log(el);
        // Caja donde van los elementos
        var formBox = document.getElementById('formBox');
        var div = document.createElement('div');
        switch(el.type){
            case 1:
                // Number
                div.innerHTML = `
                    <div id="box${el.id}" class="boxItem">
                        <span class="titleText">${el.name}</span>
                        <div>
                            <input type="number" maxlength="${el.support}" placeholder="${el.name}..." id="item/${el.id}" value="${el.content}"/>
                            <button class="buttonRow" id="saveItem/${el.id}/${index}">Guardar</button>
                        </div>
                    </div>
                `;
                break;
            case 2:
                // string
                div.innerHTML = `
                    <div id="box${el.id}" class="boxItem">
                        <span class="titleText">${el.name}</span>
                        <div>
                            <input type="number" maxlength="${el.support}" placeholder="${el.name}..." value="${el.content}"/>
                            <button class="buttonRow" id="saveItem/${el.id}/${index}">Guardar</button>
                        </div>
                    </div>
                `;
                break;
            case 3:
                // list
                let items = el.content.split('|');
                console.log(items);
                var contentItems = '';
                
                items.forEach((ele,index) => {
                    contentItems += `
                    <div class="rowItem ${((index+1) % 2) === 0 ? '' : 'rowImpar'}">
                        <input id="item/${el.id}/${index}" disabled="true" type="text" style="width: 100%;" value="${ele}" class="rowItem_${el.id}" placeholder="Ingrese..." initial="${ele}"/>
                        <img class="iconSize" src="./images/editIc.svg" alt="Edit" title="Edit" id="edit/${el.id}/${index}"/>
                        <img class="iconSize" src="./images/trash.svg" alt="Trash" title="Trash" id="delete/${el.id}/${index}" />
                        <div class="circleSpace rowAddItem noShow" id="addItemBox/${el.id}/${index}" style="width: auto;">
                            <span class="addCircle"  id="updateItem/${el.id}/${index}" ></span>
                        </div>
                        <div class="circleSpace rowAddItem noShow" id="editCloseBox/${el.id}/${index}" style="width: auto;">
                            <span class="removeCircle" id="editClose/${el.id}/${index}"></span>
                        </div>
                    </div>
                    `;
                });
                
                div.innerHTML = `
                    <div id="box${el.id}" class="boxItem">
                        <span class="titleText">${el.name}</span>
                        <div class="boxList">
                            <div class="rowNewItem">
                                <input type="text" placeholder="Ingrese..." id="newRegister_${el.id}/${index}"/>
                                <div class="circleSpace" style="width: auto;" id="newItem/${el.id}/${index}">
                                    <span class="plusCircle"></span>
                                </div>
                            </div>
                            ${contentItems}
                        </div>
                    </div>
                `;
                break;
            case 4:
                // date
                div.innerHTML = `
                    <div id="box${el.id}" class="boxItem">
                        <span class="titleText">${el.name}</span>
                        <div>
                            <input type="date" value="${el.content}"  id="item/${el.id}" />
                            <button class="buttonRow" id="saveItem/${el.id}/${index}">Guardar</button>
                        </div>
                    </div>
                `;
                break;
            case 5:
                // Boolean
                div.innerHTML = `
                    <div id="box${el.id}" class="boxItem">
                        <span class="titleText">${el.name}</span>
                        <div>
                            <div class="resetBox">
                                <label class="switch">
                                    <input type="checkbox" id="item/${el.id}" ${el.content == 1 ? 'checked="true"' : ''}>
                                    <span class="slider round"></span>
                                </label>
                                <label for="item/${el.id}">${el.name}</label>
                                <button class="buttonRow" id="saveItem/${el.id}/${index}">Guardar</button>
                            </div>
                            
                        </div>
                    </div>
                `;
                break;
        }
        formBox.appendChild(div);
    });
    
    document.querySelectorAll('[id^="delete/"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id= (this.id).split("/")[1];
            var index = (this.id).split("/")[2];
            var located = new URLSearchParams(location.search);
            var record = [];
            
            dataArr.records.forEach((el) => {
                if(id == el.id){
                    record = el;
                }
            })
            
            var arrTmp = record.content.split('|');
            arrTmp.splice(index, 1);
            
            console.log(arrTmp);
            
            updateSetting(located.get('ssid'), record.id, record.name, record.type, record.support, arrTmp.join('|'));
        });
    });
    
    document.querySelectorAll('[id^="updateItem/"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id= (this.id).split("/")[1];
            var index = (this.id).split("/")[2];
            var located = new URLSearchParams(location.search);
            var record = [];
            
            dataArr.records.forEach((el) => {
                if(id == el.id){
                    record = el;
                }
            })
            
            var itemsArr = document.getElementsByClassName('rowItem_'+id);
            var arrTmp = [];
            
            for(let i = 0; i < itemsArr.length; i++){
                arrTmp.push(itemsArr[i].value);
            }
            
            updateSetting(located.get('ssid'), record.id, record.name, record.type, record.support, arrTmp.join('|'));
        });
    });
    
    document.querySelectorAll('[id^="newItem/"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id= (this.id).split("/")[1];
            var index = (this.id).split("/")[2];
            var located = new URLSearchParams(location.search);
            var record = dataArr.records[index];
            var itemsArr = record.content.split('|');
            
            if(document.getElementById("newRegister_"+id+"/"+index).value == ""){
                alert('Campo no puede estar vacío');
            }else{
                itemsArr.push(document.getElementById("newRegister_"+id+"/"+index).value);
                updateSetting(located.get('ssid'), record.id, record.name, record.type, record.support, itemsArr.join('|'));
            }
        });
    });
    
    document.querySelectorAll('[id^="saveItem/"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id= (this.id).split("/")[1];
            var index = (this.id).split("/")[2];
            var located = new URLSearchParams(location.search);
            var record = dataArr.records[index];
            
            if( document.getElementById("item/"+id).value == ''){
                alert('Campo no puede estar vacío');
            }else{
                
                if(record.type == 5){
                    let value = document.getElementById("item/"+id).checked ? 1 : 0;
                    updateSetting(located.get('ssid'), record.id, record.name, record.type, record.support, value);
                }else{
                    updateSetting(located.get('ssid'), record.id, record.name, record.type, record.support, document.getElementById("item/"+id).value);
                }
                
            }
        });
    });
    
    document.querySelectorAll('[id^="edit/"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            cleanAll();
            var id= (this.id).split("/")[1];
            var index = (this.id).split("/")[2];
            
            document.getElementById("item/"+id+"/"+index).disabled = false;
            document.getElementById("editCloseBox/"+id+"/"+index).classList.remove("noShow");
            document.getElementById("edit/"+id+"/"+index).classList.add("noShow");
            
            document.getElementById("addItemBox/"+id+"/"+index).classList.remove("noShow");
            document.getElementById("delete/"+id+"/"+index).classList.add("noShow");
        });
    });
    
    document.querySelectorAll('[id^="editClose/"]').forEach(function (element) {
        element.addEventListener('click', function (event) {
            var id= (this.id).split("/")[1];
            var index = (this.id).split("/")[2];
            
            document.getElementById("item/"+id+"/"+index).value = document.getElementById("item/"+id+"/"+index).getAttribute('initial');
            
            document.getElementById("item/"+id+"/"+index).disabled = true;
            document.getElementById("editCloseBox/"+id+"/"+index).classList.add("noShow");
            document.getElementById("edit/"+id+"/"+index).classList.remove("noShow");
            
            document.getElementById("addItemBox/"+id+"/"+index).classList.add("noShow");
            document.getElementById("delete/"+id+"/"+index).classList.remove("noShow");
        });
    });
}

//Hace que solo este disponible 1 linea para editar    
function cleanAll(){
    document.querySelectorAll('[id^="edit/"]').forEach(function (element) {
        element.classList.remove("noShow");
    });
    document.querySelectorAll('[id^="editCloseBox/"]').forEach(function (element) {
        element.classList.add("noShow");
    });
    
    document.querySelectorAll('[id^="delete/"]').forEach(function (element) {
        element.classList.remove("noShow");
    });
    document.querySelectorAll('[id^="addItemBox/"]').forEach(function (element) {
        element.classList.add("noShow");
    });
    
    document.querySelectorAll('[id^="item/"]').forEach(function (element) {
        element.disabled = true;
    });
}

function updateSetting(sessionid, id, name, type, support, content){
    var params = {};
    
    params.sessionid = sessionid;
    params.id = id;
    params.name = name;
    params.type = type;
    params.support = support;
    params.content = content;
    
    console.log(params);
    
    callWS("POST", "settings/update", params, respxList);
    
    function respxList(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        if (status == 200){
            
            console.log(JSON.parse(respText));
            
            // Obtenemos las preferencias
            document.getElementById('formBox').innerHTML = '';
            loadSettings(sessionid, 0 ,30);
            
        }else if(status == 403){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            gotoTop();
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }else if(status == 500){
            var msg = document.getElementById('error');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}