window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    let currentLocation = document.getElementsByClassName('tests') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    loadLevels(located.get('ssid'), 1);
    loadLevels(located.get('ssid'), 2);
    loadLevels(located.get('ssid'), 3);
    loadLevels(located.get('ssid'), 4);
    loadLevels(located.get('ssid'), 5);
    loadLevels(located.get('ssid'), 6);
    
    document.getElementById('save').addEventListener('click', function () {
        var located = new URLSearchParams(location.search);
        
        // Recorremos cada nivel
        for(let i = 0; i < 6; i++){
            let params = {};
            let datalevel = document.getElementById('anwsers'+(i+1));
            
            params.level = datalevel.getAttribute('level');
            params.testid = datalevel.getAttribute('testid');
            
            params.ptsini = parseFloat(document.getElementById('initialPtsLevel'+(i+1)).value);
            
            params.ptsoklow = parseFloat(document.getElementById('ptsLowCorrectLevel'+(i+1)).value);
            params.ptsokmid = parseFloat(document.getElementById('ptsMidCorrectLevel'+(i+1)).value);
            params.ptsokheight = parseFloat(document.getElementById('ptsHighCorrectLevel'+(i+1)).value);
            
            params.ptsbadlow = parseFloat(document.getElementById('ptsLowBadLevel'+(i+1)).value);
            params.ptsbadmid = parseFloat(document.getElementById('ptsMidBadLevel'+(i+1)).value);
            params.ptsbadhigh = parseFloat(document.getElementById('ptsHighBadLevel'+(i+1)).value);
            
            params.ptsblank = parseFloat(document.getElementById('ptsBlankLevel'+(i+1)).value);
            
            for(let j = 0; j < 30; j++){
                //params['q'+(i+1)] = document.getElementById(''+(i+1)).value;
                let radioGroup = document.getElementsByName(`question${j+1}Grade${i+1}`);
                
                for(let k = 0; k < radioGroup.length; k++){
                    if(radioGroup[k].checked == true){
                        //console.log(radioGroup[k]);
                        params['q'+(j+1)] = radioGroup[k].value;
                    }
                }
                
                params['dif'+(j+1)] = parseInt(document.getElementById(`difficulty${(j+1)}Grade${i+1}Question`).value);
                params['comp'+(j+1)] = parseInt(document.getElementById(`component${j+1}Grade${i+1}Question`).value);
                params['compet'+(j+1)] = parseInt(document.getElementById(`competencies${j+1}Grade${i+1}Question`).value);
            }
            
            savePref(located.get('ssid'), params);
        }
    })
}

function loadLevels(sessionid, level){
    
     let params = {};
     
     params.sessionid = sessionid;
     params.level = level;
    
    callWS("GET",'tests/prefsentry',params,response);
    
    function response(status, respText){
        let json = JSON.parse(respText);
        
        switch(status){
            case 200:
                putQuestions(`anwsers${json.entry.level.id}`, json.entry.references.length, level, json.entry);
                break;
            case 404:
                putQuestions(`anwsers${level}`, 30, level);
                break;
            case 403:
                document.getElementById('save').disabled = true;
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                /*setTimeout(() => {
                    msg.style.display="none";
                },5000)*/
                break;
            case 500:
                document.getElementById('save').disabled = true;
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = "Error interno";
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            default:
                document.getElementById('save').disabled = true;
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = json.msg;
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
        }
    }
}

function animationMinus(id, awnser){
    let button = document.getElementById(id);
    let anwserBox = document.getElementById(awnser);
    if(button != undefined){
      button.classList.toggle('line1Change');
      anwserBox.classList.toggle('noShow');
    }
}

function putQuestions(id, questions, level, json = {}){
    let content = "";
    //console.log(level);
    
    if(!(json.id === undefined)){
        
        document.getElementById(`initialPtsLevel${json.level.id}`).value = json.points.initial;
        document.getElementById(`ptsBlankLevel${json.level.id}`).value = json.points.blank;
        
        document.getElementById(`ptsLowCorrectLevel${json.level.id}`).value = json.points.good.low;
        document.getElementById(`ptsLowBadLevel${json.level.id}`).value = json.points.bad.low;
        
        document.getElementById(`ptsMidCorrectLevel${json.level.id}`).value = json.points.good.mid;
        document.getElementById(`ptsMidBadLevel${json.level.id}`).value = json.points.bad.mid;
        
        document.getElementById(`ptsHighCorrectLevel${json.level.id}`).value = json.points.good.high;
        document.getElementById(`ptsHighBadLevel${json.level.id}`).value = json.points.bad.high;
        
        document.getElementById('anwsers'+level).setAttribute('level',json.level.id);
        document.getElementById('anwsers'+level).setAttribute('testid',json.id);
        
    }else{
        document.getElementById(`initialPtsLevel${level}`).value = 0;
        document.getElementById(`ptsBlankLevel${level}`).value = 0;
        
        document.getElementById(`ptsLowCorrectLevel${level}`).value = 0;
        document.getElementById(`ptsLowBadLevel${level}`).value = 0;
        
        document.getElementById(`ptsMidCorrectLevel${level}`).value = 0;
        document.getElementById(`ptsMidBadLevel${level}`).value = 0;
        
        document.getElementById(`ptsHighCorrectLevel${level}`).value = 0;
        document.getElementById(`ptsHighBadLevel${level}`).value = 0;
        
        document.getElementById('anwsers'+level).setAttribute('level', level);
        document.getElementById('anwsers'+level).setAttribute('testid',0);
    }
    
    for(let i = 0; i < questions; i++){
        if(i === 0){
            content += `
            <div class="dataQuestions">
                <span></span>
                <div class="radioBox">
                    <span class="titleQuestion">Respuestas correctas:</span>
                </div>
                <div class="noContent tipBox">
                    <div class="tipSpace">!</div>
                    <div class="tipDsc" style="margin-left: 0px;">
                        <span style="width: 100%;justify-content: center;">Dificultad:</span>
                        <p><b>REP:</b> Reproducción.</p>
                        <p><b>CON:</b> Conexión.</p>
                        <p><b>REF:</b> Reflexión.</p>
                    </div>
                </div>
                <div class="noContent"></div>
                <div class="noContent tipBox">
                    <div class="tipSpace">!</div>
                    <div class="tipDsc">
                        <span style="width: 100%;justify-content: center;">Competencias:</span>
                        <p><b>COM/REP/MOD:</b> Comunicación / Representación / Modelación.</p>
                        <p><b>RAZ/ARG:</b> Razonamiento y Argumentación.</p>
                        <p><b>PLA/RES:</b> Planteamiento y Resolución de Problemas.</p>
                    </div>
                </div>
            </div>`;
        }
        
        content += `
        <div class="dataQuestions">
            <span>Pregunta ${i+1}:</span>
            <div class="radioBox">
            <div>
                    <input type="radio" value="0" name="question${i+1}Grade${level}" id="${level}Grade${i+1}Question0Anwser" ${json.id === undefined ? 'checked' : json.references[i] === 0 || json.references[i] === null ? 'checked' : ''}/>
                    <label for="${level}Grade${i+1}Question0Anwser">N/A</label>
                </div>
                <div>
                    <input type="radio" value="1" name="question${i+1}Grade${level}" id="${level}Grade${i+1}Question1Anwser" ${json.id === undefined ? '' : json.references[i] == 1 ? 'checked' : ''}/>
                    <label for="${level}Grade${i+1}Question1Anwser">1</label>
                </div>
                <div>
                    <input type="radio" value="2" name="question${i+1}Grade${level}" id="${level}Grade${i+1}Question2Anwser" ${json.id === undefined ? '' : json.references[i] == 2 ? 'checked' : ''}/>
                    <label for="${level}Grade${i+1}Question2Anwser">2</label>
                </div>
                <div>
                    <input type="radio" value="3" name="question${i+1}Grade${level}" id="${level}Grade${i+1}Question3Anwser" ${json.id === undefined ? '' : json.references[i] == 3 ? 'checked' : ''}/>
                    <label for="${level}Grade${i+1}Question3Anwser">3</label>
                </div>
                <div>
                    <input type="radio" value="4" name="question${i+1}Grade${level}" id="${level}Grade${i+1}Question4Anwser" ${json.id === undefined ? '' : json.references[i] == 4 ? 'checked' : ''}/>
                    <label for="${level}Grade${i+1}Question4Anwser">4</label>
                </div>
                <div>
                    <input type="radio" value="5" name="question${i+1}Grade${level}" id="${level}Grade${i+1}Question5Anwser" ${json.id === undefined ? '' : json.references[i] == 5 ? 'checked' : ''}/>
                    <label for="${level}Grade${i+1}Question5Anwser">5</label>
                </div>
            </div>
            <select id="difficulty${i+1}Grade${level}Question">
                <option ${(json.id === undefined ? 'selected' : json.dificulty[i] === 0 || json.dificulty[i+1] === null ? 'selected' : '')} value='0'>Dificultad</option>
                <option ${(json.id === undefined ? '' : json.dificulty[i] == 1 ? 'selected' : '')} value="1">REP</option>
                <option ${(json.id === undefined ? '' : json.dificulty[i] == 2 ? 'selected' : '')} value="2">CON</option>
                <option ${(json.id === undefined ? '' : json.dificulty[i] == 3 ? 'selected' : '')} value="3">REF</option>
            </select>
            <select id="component${i+1}Grade${level}Question">
                <option ${(json.id === undefined ? 'selected' : json.components[i] === 0 || json.components[i+1] === null ? 'selected' : '')} value='0'>Componente</option>
                <option ${(json.id === undefined ? '' : json.components[i] == 1 ? 'selected' : '')} value="1">Num&eacute;rico V.</option>
                <option ${(json.id === undefined ? '' : json.components[i] == 2 ? 'selected' : '')} value="2">Geom&eacute;trico M.</option>
                <option ${(json.id === undefined ? '' : json.components[i] == 3 ? 'selected' : '')} value="3">Aleatorio</option>
            </select>
            <select id="competencies${i+1}Grade${level}Question">
                <option ${(json.id === undefined ? 'selected' : json.competencies[i] === 0 || json.competencies[i+1] === null ? 'selected' : '')} value='0'>Competencias</option>
                <option ${(json.id === undefined ? '' : json.competencies[i] == 1 ? 'selected' : '')} value="1">COM/REP/MOD</option>
                <option ${(json.id === undefined ? '' : json.competencies[i] == 2 ? 'selected' : '')} value="2">RAZ/ARG</option>
                <option ${(json.id === undefined ? '' : json.competencies[i] == 3 ? 'selected' : '')} value="3">PLA/RES</option>
            </select>
            
        </div>`;
    }
    
    document.getElementById(id).innerHTML = content;
}

function savePref(sessionid, paramsFrom){
    let params = paramsFrom;
    params.sessionid = sessionid;
    
    console.log(params);
    
    callWS("GET",'tests/prefsupdate',params,response);
    
    function response(status, resp){
        console.log(status);
        var json = JSON.parse(resp);
        console.log(json);
        switch(status){
            case 200:
                document.getElementById('anwsers'+json.level).setAttribute('level',json.level);
                document.getElementById('anwsers'+json.level).setAttribute('testid',json.id);
                break;
             case 403:
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = "No posee privilegios";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            case 500:
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = "Error interno";
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
                break;
            default:
                var msg = document.getElementById('msgApi');
                msg.style.display="block";
                msg.innerHTML = json.msg;
                gotoTop();
                
                setTimeout(() => {
                    msg.style.display="none";
                },5000)
        }
    }
}