window.onload = function carga() {
    var located = new URLSearchParams(location.search);
    
    let currentLocation = document.getElementsByClassName('tests') [0];
    currentLocation.setAttribute("id","locationUrl");
    document.getElementsByClassName('userName')[0].innerHTML = located.get('n');
    
    var params = {
        sessionid: located.get('ssid'),
        pupilid: located.get('pupilid'),
    };
    
    callPupil(params);
}

function callPupil(paramsList){
    
    callWS("GET", "tests/entry", paramsList, respxList);
    
    console.log(paramsList);
    function respxList(status, respText){
        if (status == 200){
            console.log(status);
            console.log(JSON.parse(respText));
            var json = JSON.parse(respText);
            putValues(json.entry);
            for(let i = 0; i < json.entry.test.length;i++){
                putQuestions(json.entry.test[i],json.entry.test[i].answers,i+1,json.entry.test[i].name,`${json.entry.pupil.id}_${json.entry.test[i].id}.${json.entry.test[i].extention}`);
            }
            
        }else if(status == 403){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "No posee privilegios";
            gotoTop();
        }else if(status == 500){
            var msg = document.getElementById('msgApi');
            msg.style.display="block";
            msg.innerHTML = "Error interno";
            gotoTop();
            
            setTimeout(() => {
                msg.style.display="none";
            },5000)
        }
    }
}

const innerInInputs = (id,value) => {
    document.getElementById(id).value = value;
}

function putValues(json){
    innerInInputs('pupilName',json.pupil.name);
    innerInInputs('surname',json.pupil.surname);
    innerInInputs('birth',json.pupil.birthdate.formatted);
    innerInInputs('gender',json.pupil.gender.dsc);
    innerInInputs('ci',json.pupil.ci);
    innerInInputs('code',json.pupil.code);
    innerInInputs('collegeName',json.school.name);
    innerInInputs('state',json.school.region);
    innerInInputs('grade',`${json.pupil.level} - ${json.pupil.section}`);
}

function animationMinus(id, exam){
    let button = document.getElementById(id);
    let examBox = document.getElementById(exam);
    if(button != undefined){
      button.classList.toggle('line1Change');
      examBox.classList.toggle('noShow');
    }
}

function putQuestions(test, questions, idExam, name, img){
    let content = "";
    console.log(questions + " " + idExam);
        
    for(let i = 0; i < questions.length; i++){
        if(i === 0){
            content += `
            <div class="titleBox displayEl" onclick="animationMinus('line${idExam}exam', 'exam${idExam}')">
                <div class="titleEye">
                    <span>${name}</span>
                    <i class="eye"></i>
                </div>
        
                <div class="plusBox">
                    <span class="line1" id="line${idExam}exam"></span>
                    <span class="line2"></span>
                </div>
            </div>
            <div class="noShow anwsersTest" id="exam${idExam}">`;
        
            content += `
            ${ test.extention === null ? `<p style='text-align:center;color: #1A2454;'>Alumno no posee examen escaneado</p>` : `<img alt="Examen" class="examImg" src="./uploads/assigned/${img}"/>`}
            <div class="dataQuestions">
                <span></span>
                <div class="radioBox">
                    <span class="titleQuestion">Respuestas:</span>
                </div>
                <div class="noContent">
                    <span class="titleQuestion">Puntos:</span>
                </div>
            </div>
            <div class='anwsersBoxTest'>`;
        }
        
        content += `
        <div class="dataQuestions">
            <span>Pregunta ${i+1}:</span>
            <div class="radioBox">
            <div>
                    <input type="radio" value="0" name="question${i+1}Exam${idExam}" id="${idExam}exam${i+1}Question0Anwser" 
                    ${parseInt(questions[i]) === 0 ? "checked" : ''}/>
                    <label for="${idExam}exam${i+1}Question0Anwser">N/C</label>
                </div>
                <div>
                    <input type="radio" value="1" name="question${i+1}Exam${idExam}" id="${idExam}exam${i+1}Question1Anwser" 
                    ${parseInt(questions[i]) === 1 ? "checked" : ''}/>
                    <label for="${idExam}exam${i+1}Question1Anwser" ${(parseInt(test.references[i]) == 1 ? `style='color:green;text-decoration: underline;'` : '')}>1</label>
                </div>
                <div>
                    <input type="radio" value="2" name="question${i+1}Exam${idExam}" id="${idExam}exam${i+1}Question2Anwser" 
                    ${parseInt(questions[i]) === 2 ? "checked" : ''}/>
                    <label for="${idExam}exam${i+1}Question2Anwser" ${(parseInt(test.references[i]) == 2 ? `style='color:green;text-decoration: underline;'` : '')}>2</label>
                </div>
                <div>
                    <input type="radio" value="3" name="question${i+1}Exam${idExam}" id="${idExam}exam${i+1}Question3Anwser" 
                    ${parseInt(questions[i]) === 3 ? "checked" : ''}/>
                    <label for="${idExam}exam${i+1}Question3Anwser" ${(parseInt(test.references[i]) == 3 ? `style='color:green;text-decoration: underline;'` : '')}>3</label>
                </div>
                <div>
                    <input type="radio" value="4" name="question${i+1}Exam${idExam}" id="${idExam}exam${i+1}Question4Anwser" 
                    ${parseInt(questions[i]) === 4 ? "checked" : ''}/>
                    <label for="${idExam}exam${i+1}Question4Anwser" ${(parseInt(test.references[i]) == 4 ? `style='color:green;text-decoration: underline;'` : '')}>4</label>
                </div>
                <div>
                    <input type="radio" value="5" name="question${i+1}Exam${idExam}" id="${idExam}exam${i+1}Question5Anwser" 
                    ${parseInt(questions[i]) === 5 ? "checked" : ''}/>
                    <label for="${idExam}exam${i+1}Question5Anwser" ${(parseInt(test.references[i]) == 5 ? `style='color:green;text-decoration: underline;'` : '')}>5</label>
                </div>
            </div>
            <input type="text" style="text-align: center;" id="pointsExam${idExam}Question${i+1}" readonly value="${test.qualification[i]}"/>
        </div>`;
    }
    
    content += `</div></div>`;
    
    document.getElementById("exams").innerHTML += content;
}