function validate() {
    var located = new URLSearchParams(location.search);
    //Validar correo
    var rgx = /^[-\w.%+]{1,64}@(?:[A-Z0-9-]{1,63}\.){1,125}[A-Z]{2,63}$/i;
    //Validar telefono
    var valNumber=/^([\(\)\-0-9]+){13,13}?$/;
    //validar pwd
    var valPwd = /^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[!@#\$%\^&\*\_\-\(\)\,\.])(?=.{8,31}$)/g;
    
    var params = {
        contact: document.getElementById('name').value,
        email: document.getElementById('mail').value,
        position: document.getElementById('position').value,
        phone: document.getElementById('phone').value,
        pwd: document.getElementById('pass').value,
        phonesecundary:null,
        contactalt:null,
        positionalt: null,
        emailalt:null,
        phonealt: null,
        hash: located.get('hash'),
    };
    
    var pwdConfirm = document.getElementById('repeatPass').value;
    var error = document.getElementById('error');
    
    if( params.contact === "" || params.email === "" || params.position === "" || params.phone === "" || params.pwd === "" || pwdConfirm === ""){
        error.innerHTML = "No pueden haber campos vacíos";
    }else if(!rgx.test(params.email)) {
        error.innerHTML = "El Correo Electrónico no es válido";
    }else if(!valNumber.test(params.phone) || params.phone.length != 13){
        error.innerHTML = "El número de teléfono no es válido";
    }else if(params.pwd.length < 8){
        error.innerHTML = `La contrase\u00F1a debe contener m\u00EDnimo 8 caracteres`;
        /*if(!valPwd.test(params.pwd)){
        error.innerHTML = `La contrase\u00F1a debe contener:<br>
        -Entre 8 y 32 caracteres.<br>
        -Contener m\u00EDnimo 1 may\u00FAscula, min\u00FAscula y n\u00FAmero.<br>
        -Contener 1 car\u00E1cter especial como * \ ( ) -.`;*/
    }else if( params.pwd != pwdConfirm) {
        error.innerHTML = "Las contraseñas no coinciden";
    } else{
         error.innerHTML = "";
         params.pwd = MD5(params.pwd);
         loadScreen();
         callWS("GET", "login/saveregister", params, respx);
    }
    
    function respx(status, respText){
        console.log(status);
        console.log(JSON.parse(respText));
        closeLoad();
        if ( status == 200 ){
            var params ={
                name: JSON.parse(respText).name,
                school: JSON.parse(respText).school.name,
                i: JSON.parse(respText).school.id,
                pri: JSON.parse(respText).school.private,
                ssid: JSON.parse(respText).sessionid,
            };
            setSessionId(JSON.parse(respText).sessionid)
            gotoPage('home','main',params);
        } else if ( status == 401 ) {
            error.innerHTML = "Hash incorrecto";
        }
    }
}

window.onload = function carga() {
    var email = document.getElementById('email');
    var located = new URLSearchParams(location.search);
    var phone = document.getElementById('phone');
    
    if(located.get('email') == null){
        gotoPage('login','main',{});
    }
    
    document.getElementById('mail').value = located.get('email');
    document.getElementById('collegeName').innerHTML = located.get('college');
    
    //Mostrar pwd
    document.getElementById('eyePwd').addEventListener("click", function(){
        showHide('pass');
    });
    
    //Mostrar repetir pwd
    document.getElementById('eyeRepeatPwd').addEventListener("click", function(){
        showHide('repeatPass');
    });
    
    //Registrarse
    document.getElementById('register').addEventListener("click", function(){
        validate();
    });
    
    document.body.addEventListener("keydown",function (e) {
        if (e.keyCode === 13) {
            validate();
        }
    });
    
    //Formateo del telefono
    phone.addEventListener("keydown",function () { formatedphone(phone)});
    
    function formatedphone(input){
        var valNumber=/^(([0-9])|(ext|x)){1,11}$/;
        var originalNumber = "";
        var number = input.value.replace(/[(,),-]/g,"");
        input.value = "";
        var numbers = number.split("");
        console.log(numbers);
        
        for(let i = 0; i < numbers.length; i++){
            
            if(i === 0){
                originalNumber += "(" + numbers[i];
            }else if( i == 3){
                originalNumber += ")" + numbers[i];
            }else if( i == 6){
                originalNumber += "-" + numbers[i];
            }else{
                originalNumber += numbers[i];
            }
        }
        input.value = originalNumber;
    }
}

function showHide(pwd){
    let inputPass = document.getElementById(pwd);
    
    inputPass.type === "password" ? inputPass.type = "text" : inputPass.type = "password";
}