<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("pupilid");
    if (!parametrosValidos($_GET, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));
    
    $sql =  "SELECT     CONCAT(P.name, ' ', P.surname) fullname, " .
            "           P.id pupilid, S.id, S.name, S.region " .
            "FROM       pupils P " .
            "INNER JOIN schools S " .
            "ON         P.schoolid = S.id " .
            "WHERE      status = 1 " .
            "AND        CONCAT(LPAD(P.id,'7','0'),RIGHT(CRC32(P.id),2))='" . str_pad($_GET["pupilid"], 9, "0",STR_PAD_LEFT) . "'";
   
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));
    
    $out = new stdClass();
    if ($row = $rs->fetch_assoc()){
        $out->id = (integer) $row["pupilid"];
        $out->pupilid = $_GET["pupilid"];
        $out->fullname = $row["fullname"];
    }else{
        badEnd("401", array("msg"=>"ID no encontrado"));
    }

    // armar query con escuelas
    $sql =  "SELECT     id, name, region " .
            "FROM (" .
            "(SELECT     id, name, region " .
            "FROM       schools " .
            "WHERE      id=" . $row["id"] . ") " . 
            "UNION " .
            "(SELECT     id, name, region " .
            "FROM       schools " .
            "ORDER BY   RAND() " .
            "LIMIT      4)) A " .
            "ORDER BY   RAND()";
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error));

    $schools = array();
    while ($row = $rs->fetch_assoc()){
        $schools[] = array("id"=>(integer)$row["id"],"name"=>$row["name"],"region"=>$row["region"]);
    }
    
    $out->schools = $schools;
    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
