function init(){
    //Submit login
    document.getElementById("schoolBtn").addEventListener("click", function(){
        var schools = document.getElementsByName("schoolItem");
        schools.forEach(function(item){
            if(item.checked){                
                schoolCheck();
                return;
            }
        });  
    });
    //Blanquear data y volver a mostrar el popup de login
    document.getElementById("continue").addEventListener("click",function(){        
        sessionStorage.clear();
        gotoPage("login", "main", {});
    });
    var schools = JSON.parse(sessionStorage.getItem("session")).schools;
    if(schools == undefined){
        //Si no existe la lista de escuelas sacar al login
        sessionStorage.clear();
        gotoPage("login", "main", {});
        return;
    }
    if(schools.length>0){        
        drawSchools(schools);
    }
    /***fin***/
}

//FUNCION PARA INGRESAR LLAMADA AL SERVIDOR
function schoolCheck(){
    var parms = {};
    parms.pupilid = JSON.parse(sessionStorage.getItem("session")).pupilid;
    var schools = document.getElementsByName("schoolItem");
    schools.forEach(function(item){
        if(item.checked){
            parms.schoolid = item.value;            
            return;
        }
    });    
    var url = "login/checkschool";
    var onsucces = function(rsp, status){
        switch(status){
            case 200:
                //CONTENIDO RELEVANTE
                console.log(rsp);
                sessionStorage.setItem("session",JSON.stringify(rsp));     
                gotoPage("login", "confirm", {});
            break;
            case 401:      
                console.log(rsp);          
                document.getElementById("errlogCode").value = parms.pupilid;
                document.getElementById("errMsg").innerHTML = "Lo sentimos. El colegio seleccionado no coincide con el ID de estudiante ingresado.";                
                sessionStorage.clear();
                showForm("errorForm");
            break;            
            case 403:
                test = rsp;
                sessionStorage.setItem("test",JSON.stringify(test));
                gotoPage("home", "congrats", {});
                console.log(rsp);
            break;
            case 500:
                console.log(rsp);
                document.getElementById("errlogCode").value = "Error interno del sistema.";  
                showForm("errorForm");
                sessionStorage.clear();
            break;
            default:
                console.log(rsp);
            break;
        }
    }
    callWS("POST", url, parms, onsucces);
}

function drawSchools(rsp){
    var tbl = document.getElementById("schoolsList");
    var node = tbl.firstElementChild.cloneNode(true);
    var tmp = null; tmp = node.cloneNode(true);
    tbl.innerHTML = "";
    if(!(rsp.length>0)){
        var ele = null;
        ele = tmp.cloneNode(true);
        ele.style.display = "none";
        tbl.appendChild(ele);
    }else{
        for(var i=0; i<rsp.length; i++){
            var ele = null;
            ele = tmp.cloneNode(true);
            ele.style.display = "";
            //Bg del reglon
            var check = ele.children[0];
            var inptCheck = check.children[0].children[0];
            inptCheck.setAttribute("name","schoolItem");
            inptCheck.setAttribute("value",rsp[i].id);
            inptCheck.setAttribute("id",rsp[i].id);
            inptCheck.nextElementSibling.setAttribute("for",rsp[i].id);

            var school = ele.children[1];           
            school.children[0].innerHTML = rsp[i].name;
            school.children[1].innerHTML = rsp[i].region;
            
            tbl.appendChild(ele);
        }
    }
}

/**Iniciar**/
window.onload = function(){
    init();

    //Deshabilitar el back
    noBack();
    document.body.setAttribute("onpageshow","if(event.persisted)noBack();");
}
