<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("pupilid","testid","questionordinal");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $pupilid = (integer) substr($_REQUEST["pupilid"], 0, -2);
    $questionordinal = (integer) $_REQUEST["questionordinal"];
    $testid = (integer) $_REQUEST["testid"];
    $out = new stdClass();

    // obtener id de la respuesta
    $sql =  "SELECT     A.id " .
            "FROM       answers A " .
            "INNER JOIN tests T " .
            "ON         A.testid=T.id " .
            "WHERE      A.pupilid='" . $pupilid . "' " .
            "AND        T.status=1 " .
            "AND        T.id = " . $testid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
    if (!$row = $rs->fetch_assoc())
        badEnd("404", array("msg"=>"Combinacion Prueba / Usuario inválida"));
    
    // traer imagen
    $img = false;
    foreach($_FILES as $image){
        switch ($image["type"]){
            case "image/jpeg":
            case "image/jpg":
                $ext = "jpg";
                break;
            case "image/png":
                $ext = "png";
                break;
        }
        $dst = "../../../uploads/answers/" . $row["id"];
        if (!file_exists($dst))
            if (!mkdir($dst))
                badEnd("500", array("msg"=>"Imposible crear directorio: " . $dst));

        $src = $image["tmp_name"];
        // calcular numero del siguiente archivo
        $nextfile = 1;
        while (file_exists($dst . "/" . str_pad($questionordinal,2,"0",STR_PAD_LEFT) . "_" . str_pad($nextfile,3,"0",STR_PAD_LEFT) . "." . $ext))
            $nextfile++;

        $dst = $dst . "/" . str_pad($questionordinal,2,"0",STR_PAD_LEFT) . "_" . str_pad($nextfile,3,"0",STR_PAD_LEFT) . "." . $ext;
        if (!move_uploaded_file($src, $dst))
            badEnd("500", array("msg"=>"error del archivo subido: " . $dst));
        $img = true;
    }

    if (!$img)
        badEnd("400", array("msg"=>"No se recibió ninguna imagen "));

    // buscar attachments
    $out->attachments = array();
    $dir = "../../../uploads/answers/" . $row["id"];
    if (file_exists($dir)){
        $files = scandir($dir);
        foreach ($files as $file){
            if (!in_array($file,array(".","..")) && substr($file,0,2) == str_pad($questionordinal,2,"0",STR_PAD_LEFT)){
                $out->attachments[] = array("filename"=>$file, 
                                            "url"=>"../uploads/answers/" . $row["id"] ."/" . $file);
            }
        }
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
