<?php
    header("Content-Type:application/json");
    include("../connection.php");
    include("../utils.php");
    
    // parametros obligatorios
    $parmsob = array("pupilid","testid","questionordinal");
    if (!parametrosValidos($_REQUEST, $parmsob))
        badEnd("400", array("msg"=>"Parametros obligatorios " . implode(", ", $parmsob)));

    $pupilid = (integer) substr($_REQUEST["pupilid"], 0, -2);
    $testid = (integer) $_REQUEST["testid"];
    $response = $_REQUEST["response"];
    $out = new stdClass();

    // parametros opcionales
    $direction = 1;
    if (parametrosValidos($_REQUEST, array("direction")))
        $direction = $_REQUEST["direction"];

    // verificar que aún haya tiempo
    $sql =  "SELECT     T.id testid, T.maxminutes, T.numofquestions, " .
            "           ROUND((UNIX_TIMESTAMP() - UNIX_TIMESTAMP(A.datestart)) / 60) remmin, " .
            "           TIMESTAMPDIFF(MINUTE,A.datestart,IFNULL(A.dateend,A.datestart+T.maxminutes)) totalminutes " .
            "FROM       answers A " . 
            "INNER JOIN tests T " .
            "ON         A.testid = T.id " .
            "WHERE      T.status = 1 " .
            "AND        A.pupilid=" . $pupilid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
    if ($row = $rs->fetch_assoc()){
        // verificar que el tiempo no se haya excedido
        if ($row["maxminutes"]-$row["remmin"] < 0){
            badEnd("401", array("msg"=>"Plazo del examen vencido","totalminutes"=>$row["totalminutes"]));
        }
    }else{
        badEnd("500", array("msg"=>"No se encontró la prueba"));
    }
    $minutesremain = (integer)$row["maxminutes"]-(integer)$row["remmin"];
    $numofquestions = (integer) $row["numofquestions"];
    $out->minutesremain = $minutesremain;
    $out->numofquestions = $numofquestions;

    // si es la ultima respuesta se cierra la prueba
    if ((integer) $_REQUEST["questionordinal"] >= $numofquestions && $direction == 1){
        $closetest = ", dateend=NOW() ";
    }else{
        $closetest = "";
    }

    // actualizar respuesta
    $sql =  "UPDATE     answers " .
            "SET        q" . (integer) $_REQUEST["questionordinal"] . "='" . $response . "' " .
            $closetest .
            "WHERE      pupilid=" . $pupilid . " " .
            "AND        testid=" . $testid;
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
    
    // buscar utlima pregunta respondida
    $sql =  "SELECT     q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, " .
            "           q11, q12, q13, q14, q15, q16, q17, q18, q19, q20, " .
            "           q21, q22, q23, q24, q25, q26, q27, q28, q29, q30, " .
            "           ROUND((UNIX_TIMESTAMP() - UNIX_TIMESTAMP(datestart)) / 60) remmin, " .
            "           TIMESTAMPDIFF(MINUTE,A.datestart,IFNULL(A.dateend,NOW())) totalminutes " .
            "FROM       answers A " . 
            "WHERE      pupilid=" . $pupilid . " " .
            "AND        testid=" . $_REQUEST["testid"];
    if (!$rs=$db->query($sql))
        badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
    if (!$row = $rs->fetch_assoc())
        badEnd("500", array("msg"=>"No se consigio la respuesta", "sql"=>$sql));

    $nextq = (integer) $_REQUEST["questionordinal"];
    if ($direction == 1 && (integer) $_REQUEST["questionordinal"] <= $numofquestions){
        $nextq = (integer) $_REQUEST["questionordinal"] + 1;
    }
    if ($direction == -1 && (integer) $_REQUEST["questionordinal"] > 1){
        $nextq = (integer) $_REQUEST["questionordinal"] - 1;
    }

    // busca siguiente pregunta sin contestar
    /*
    $nextq = -1;
    for ($i=0; $i<$numofquestions+1; $i++){
        if ($row["q".($i+1)] == null){
            $nextq = $i+1;
            $i = $numofquestions;
        }
    }
    */

    $out->test = new stdClass();
    //Tiempo maximo de la prueba por si el forn necesita sacar por finalizado - JR
    $out->test->maxminutes = (integer)$row["maxminutes"];
    // Si esta completamente respondido se devuelven los datos de finalización
    $out->test->ended = $numofquestions < $nextq;
    $out->test->totalminutes = (integer) $row["totalminutes"];

    if (!$out->test->ended){
        // obtener siguiente pregunta
        $sql =  "SELECT     Q.ordinal, Q.type qtype, Q.id qid, Q.testid, Q.label qlabel, Q.statement, Q.imagetype qimage, " .
                "           O.id oid, O.label olabel, O.dsc, O.imagetype oimage, O.ord, Q.backuprequired " .
                "FROM       questions Q " .
                "INNER JOIN options O " .
                "ON         Q.id = O.questionid " .
                "WHERE      Q.ordinal=" . $nextq . " " .
                "AND        Q.testid=" . $_REQUEST["testid"] . " " .
                "ORDER BY   O.ord";
        if (!$rs=$db->query($sql))
            badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
        
        $first = true;
        while ($row = $rs->fetch_assoc()){
            if ($first){
                $first = false;
                $out->test->questions = new stdClass();
                $out->test->questions->next = new stdClass();
                $out->test->questions->next->ordinal = (integer) $row["ordinal"];
                $out->test->questions->next->type = (integer) $row["qtype"];
                $out->test->questions->next->backuprequired = (boolean) $row["backuprequired"]==1;
                $out->test->questions->next->id = (integer) $row["qid"];
                $out->test->questions->next->label = $row["qlabel"];
                $out->test->questions->next->statement = $row["statement"];
                $out->test->questions->next->image = new stdClass();
                $datatype = nvl($row["qimage"],"");
                $url = "";
                if ($datatype != ""){
                    $type = explode("/",$datatype);
                    if ($type[0]=="image"){
                        $url = "../uploads/tests/".$row["testid"]."/".$row["qid"]."/question.".$type[1];
                        if (!file_exists("../../".$url)){
                            $datatype = "";
                            $url = "";
                        }
                    }
                }
                $out->test->questions->next->image->type = $datatype;
                $out->test->questions->next->image->url = $url;
                $out->test->questions->next->options = array();
            }
            $option = new stdClass();
            $option->id = (integer) $row["oid"];
            $option->ordinal = (integer) $row["ord"];
            $option->label = $row["olabel"];
            $option->dsc = $row["dsc"];
            $option->image = new stdClass();
            $datatype = nvl($row["oimage"],"");
            $url = "";
            if ($datatype != ""){
                $type = explode("/",$datatype);
                if ($type[0]=="image"){
                    $url = "../uploads/tests/".$row["testid"]."/".$row["qid"]."/".$row["oid"].".".$type[1];
                    if (!file_exists("../../".$url)){
                        $datatype = "";
                        $url = "";
                    }
                }
            }
            $option->image->type = $datatype;
            $option->image->url = $url;

            // buscar respuesta
            $sql =  "SELECT     id, q" . $out->test->questions->next->ordinal . " answs " .
                    "FROM       answers " .
                    "WHERE      testid=" . $row["testid"] . " " .
                    "AND        pupilid=" . $pupilid;
            if (!$rsansws=$db->query($sql))
                badEnd("500", array("msg"=>$db->error, "sql"=>$sql));
            $row2 = $rsansws->fetch_assoc();
            $out->test->questions->next->answers = nvl($row2["answs"],"");

            // buscar attachments
            $out->test->questions->next->attachments = array();
            $dir = "../../../uploads/answers/" . $row2["id"];
            if (file_exists($dir)){
                $files = scandir($dir);
                foreach ($files as $file){
                    if (!in_array($file,array(".","..")) && substr($file,0,2) == str_pad($out->test->questions->next->ordinal,2,"0",STR_PAD_LEFT)){
                        $out->test->questions->next->attachments[] = array("filename"=>$file, 
                                                                        "url"=>"../uploads/answers/" . $row2["id"] ."/" . $file);
                    }
                }
            }

            $out->test->questions->next->options[] = $option;
        }
    }

    header("HTTP/1.1 200");
    echo (json_encode($out));
    die();
?>
